% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampling.R
\name{subsample.fossils.uniform}
\alias{subsample.fossils.uniform}
\title{Obtain a uniform random sample of fossil occurrences.}
\usage{
subsample.fossils.uniform(fossils, proportion)
}
\arguments{
\item{fossils}{an object of class "fossils" that corresponds to fossil
occurrences.}

\item{proportion}{the proportion of all fossil samples to return in the
subsample.}
}
\value{
an object of class "fossils" containing the subsampled fossil
  occurrences.
}
\description{
Obtain a uniform random sample of fossil occurrences.
}
\examples{
t = TreeSim::sim.bd.taxa(10, 1, 0.1, 0.05)[[1]]
f = sim.fossils.poisson(0.1, t, root.edge = FALSE)
subsample.fossils.uniform(f, 0.5)
}
