% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prognosis.R
\name{lasso_pro}
\alias{lasso_pro}
\title{Train a Lasso Cox Proportional Hazards Model}
\usage{
lasso_pro(X, y_surv, tune = FALSE)
}
\arguments{
\item{X}{A data frame of features.}

\item{y_surv}{A \code{survival::Surv} object representing the survival outcome.}

\item{tune}{Logical, whether to perform hyperparameter tuning (currently simplified/ignored
for direct \code{cv.glmnet} usage which inherently tunes lambda).}
}
\value{
A list of class "train" containing the trained \code{glmnet} model object,
names of features used in training, and model type. The returned object
also includes \code{fitted_scores} (linear predictor) and \code{y_surv}.
}
\description{
Trains a Cox proportional hazards model with Lasso regularization
using \code{glmnet}.
}
\examples{
set.seed(42)
n_samples <- 50
n_features <- 10
X_data <- as.data.frame(matrix(rnorm(n_samples * n_features), ncol = n_features))
Y_surv_obj <- survival::Surv(
  time = runif(n_samples, 100, 1000),
  event = sample(0:1, n_samples, replace = TRUE)
)

# Train the model
lasso_model <- lasso_pro(X_data, Y_surv_obj)
print(lasso_model$finalModel)
}
