% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapseCohorts.R
\name{collapseCohorts}
\alias{collapseCohorts}
\title{Collapse cohort entries using a certain gap to concatenate records.}
\usage{
collapseCohorts(
  cohort,
  cohortId = NULL,
  gap = 0,
  name = tableName(cohort),
  .softValidation = FALSE
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{gap}{Number of days between two subsequent cohort entries to be merged
in a single cohort record.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{.softValidation}{Whether to perform a soft validation of consistency.
If set to FALSE four additional checks will be performed: 1) a check that
cohort end date is not before cohort start date,  2) a check that there
are no missing values in required columns, 3) a check that cohort duration is
all within observation period, and 4) that there are no overlapping
cohort entries}
}
\value{
A cohort table
}
\description{
\code{collapseCohorts()} concatenates cohort records, allowing for some number
of days between one finishing and the next starting.
}
