% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdgetDatasetsList_hdf5}
\alias{bdgetDatasetsList_hdf5}
\title{List Datasets in HDF5 Group}
\usage{
bdgetDatasetsList_hdf5(filename, group, prefix = NULL)
}
\arguments{
\item{filename}{Character string. Path to the HDF5 file.}

\item{group}{Character string. Path to the group within the HDF5 file.}

\item{prefix}{Optional character string. If provided, only returns datasets
starting with this prefix.}
}
\value{
Character vector containing dataset names.
}
\description{
Retrieves a list of all datasets within a specified HDF5 group, with optional
filtering by prefix or suffix.
}
\details{
This function provides flexible dataset listing capabilities for HDF5 files.
Key features:
\itemize{
\item Listing options:
\itemize{
\item All datasets in a group
\item Datasets matching a prefix
\item Datasets matching a suffix
}
\item Implementation features:
\itemize{
\item Safe HDF5 file operations
\item Memory-efficient implementation
\item Comprehensive error handling
\item Read-only access to files
}
}

The function opens the HDF5 file in read-only mode to ensure data safety.
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create a test HDF5 file
fn <- "test.hdf5"
X <- matrix(rnorm(100), 10, 10)
Y <- matrix(rnorm(100), 10, 10)

# Save matrices to HDF5
bdCreate_hdf5_matrix(fn, X, "data", "matrix1",
                     overwriteFile = TRUE)
bdCreate_hdf5_matrix(fn, Y, "data", "matrix2",
                     overwriteFile = FALSE)

# List all datasets in group
datasets <- bdgetDatasetsList_hdf5(fn, "data")
print(datasets)

# List datasets with prefix "matrix"
filtered <- bdgetDatasetsList_hdf5(fn, "data", prefix = "matrix")
print(filtered)

# Cleanup
if (file.exists(fn)) {
  file.remove(fn)
}
}

}
\references{
\itemize{
\item The HDF Group. (2000-2010). HDF5 User's Guide.
}
}
\seealso{
\itemize{
\item \code{\link{bdCreate_hdf5_matrix}} for creating HDF5 matrices
}
}
