% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflowfunction.R
\name{UpdateBiclust_RowNoise}
\alias{UpdateBiclust_RowNoise}
\title{Update a Biclust or BiBitWorkflow Object with a new Noise Level}
\usage{
UpdateBiclust_RowNoise(result, matrix, noise = 0.1, noise_select = 0,
  removeBC = FALSE)
}
\arguments{
\item{result}{A Biclust or BiBitWorkflow Object.}

\item{matrix}{Accompanying binary data matrix which was used to obtain \code{result}.}

\item{noise}{The new noise level which should be used in the rows of the biclusters. (default=\code{0.1}, namely allow 10\% noise.).
\itemize{
\item \code{noise=0}: No noise allowed.
\item \code{0<noise<1}: The \code{noise} parameter will be a noise percentage. The number of allowed 0's in a row in the bicluster will depend on the column size of the bicluster.
More specifically \code{zeros_allowed = ceiling(noise * columnsize)}. For example for \code{noise=0.10} and a bicluster column size of \code{5}, the number of allowed 0's would be \code{1}.
\item \code{noise>=1}: The \code{noise} parameter will be the number of allowed 0's in a row in the bicluster independent from the column size of the bicluster. In this noise option, the noise parameter should be an integer.
}}

\item{noise_select}{Should the allowed noise level be automatically selected for each pattern? (Using ad hoc method to find the elbow/kink in the Noise Scree plots)
\itemize{
\item \code{noise_select=0}: Do \emph{NOT} automatically select the noise levels. Use the the noise level given in the \code{noise} parameter (default)
\item \code{noise_select=1}: Using the Noise Scree plot (with 'Added Rows' on the y-axis), find the noise level where the current number of added rows at this noise level is larger than the mean of 'added rows' at the lower noise levels. 
After locating this noise level, lower the noise level by 1. This is your automatically selected elbow/kink and therefore your noise level.
\item \code{noise_select=2}: Applies the same steps as for \code{noise_select=1}, but instead of decreasing the noise level by only 1, keep decreasing the noise level until the number of added rows isn't decreasing anymore either.
}}

\item{removeBC}{\emph{(Only applicable when result is a Biclust object)} Logical value if after applying a new noise level, duplicate and non-maximal BC's should be deleted.}
}
\value{
A \code{Biclust} or \code{BiBitWorkflow} Object (See Details)
}
\description{
Apply a new noise level on a Biclust object result or BiBitWorkflow result. See Details on how both objects are affected.
}
\details{
\describe{
\item{\emph{Biclust S4 Object}}{
Using the column patterns of the Biclust result, new grows are grown using the inputted \code{noise} level.
The \code{removeBC} parameter decides if duplicate and non-maximal BC's should be deleted. Afterwards a new \code{Biclust} S4 object is returned with the new biclusters.
}
\item{\emph{BiBitWorkflow S3 Object}}{
The merged column patterns (after cutting the hierarchical tree) are extracted from the BiBitWorkflow object, namely the \code{$info$MergedColPatterns} slot. 
Afterwards, using the new \code{noise} level, new rows are grown and the returned object is an updated \code{BiBitWorkflow} object. (e.g. The final Biclust slot, MergedNoiseThresholds, coverage,etc. are updated)
}
}
}
\examples{
\dontrun{
## Prepare some data ##
set.seed(254)
mat <- matrix(sample(c(0,1),5000*50,replace=TRUE,prob=c(1-0.15,0.15)),
              nrow=5000,ncol=50)
mat[1:200,1:10] <- matrix(sample(c(0,1),200*10,replace=TRUE,prob=c(1-0.9,0.9)),
                          nrow=200,ncol=10)
mat[300:399,6:15] <- matrix(sample(c(0,1),100*10,replace=TRUE,prob=c(1-0.9,0.9)),
                            nrow=100,ncol=10)
mat[400:599,21:30] <- matrix(sample(c(0,1),200*10,replace=TRUE,prob=c(1-0.9,0.9)),
                             nrow=200,ncol=10)
mat[700:799,29:38] <- matrix(sample(c(0,1),100*10,replace=TRUE,prob=c(1-0.9,0.9)),
                             nrow=100,ncol=10)
mat <- mat[sample(1:5000,5000,replace=FALSE),sample(1:50,50,replace=FALSE)]

## Apply BiBitWorkflow ##
out <- BiBitWorkflow(matrix=mat,minr=50,minc=5,noise=0.1,cut_type="number",cut_pm=4)
summary(out$Biclust)

## Update Rows with new noise level on Biclust Obect -> returns Biclust Object ##
out_new <- UpdateBiclust_RowNoise(result=out$Biclust,matrix=mat,noise=0.3)
summary(out_new)
out_new@info$Noise.Threshold # New Noise Levels

## Update Rows with new noise level on BiBitWorkflow Obect -> returns BiBitWorkflow Object ##
out_new2 <- UpdateBiclust_RowNoise(result=out,matrix=mat,noise=0.2)
summary(out_new2$Biclust)
out_new2$info$MergedNoiseThresholds # New Noise Levels
}
}
\author{
Ewoud De Troyer
}

