% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summastat.R
\name{summastat}
\alias{summastat}
\title{Summary statistics}
\usage{
summastat(x, sigf, varname, plot = TRUE)
}
\arguments{
\item{x}{A vector of numeric values.}

\item{sigf}{The number of significant figures to report (optional).}

\item{varname}{The name of the variable (optional), character so in quotes e.g.
"Clay content". If not used then the variable is called x on plots.}

\item{plot}{If \code{TRUE}, a plot is part of the output. If \code{FALSE}, plot
is not part of output (default is \code{TRUE}).}
}
\value{
A matrix containing the mean value, median value,
  first and third quartiles, sample variance, sample standard deviation,
  coefficient of skewness, octile skewness, coefficient of kurtosis and
  the number of probable outliers in a data set. A histogram with a boxplot
  over it and QQ plot of the variable x if \code{plot=TRUE}.
}
\description{
A function to calculate summary statistics of a set of data.
}
\examples{
x<-evapotranspiration$`ET(mm)`
summastat(x,2)


}
\author{
Richard Murray Lark <murray.lark@nottingham.ac.uk>
}
