% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_useful_functions.R
\name{calculate_exact_changepoint_posterior}
\alias{calculate_exact_changepoint_posterior}
\title{Calculates the exact posterior for a sequence with a single change-point.}
\usage{
calculate_exact_changepoint_posterior(input_data, depth, alphabet)
}
\arguments{
\item{input_data}{the sequence to be analysed.}

\item{depth}{maximum memory length.}

\item{alphabet}{symbols appearing in the sequence.}
}
\value{
empirical posterior of the change-points locations.
}
\description{
This function calculates the exact posterior for a sequence with a single change-point.
}
\examples{
# Use the first 300 samples of the simian_40 dataset.
# Run the function with 1 change-point, a maximum depth of 2 and the ["a", "c", "g", "t"] alphabet.

res <- calculate_exact_changepoint_posterior(substr(simian_40, 1, 300), 2, c("acgt"))
}
\seealso{
\code{\link{infer_unknown_changepoints}}
}
