% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/allen-relations.R
\docType{methods}
\name{allen_composition}
\alias{allen_composition}
\alias{allen_composition-method}
\alias{allen_composition,character,character-method}
\title{Composition of Allen Relations}
\usage{
allen_composition(x, y, ...)

\S4method{allen_composition}{character,character}(x, y)
}
\arguments{
\item{x, y}{A \code{\link{character}} vector of Allen relations.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{character}} vector.
}
\description{
Composition of Allen Relations
}
\examples{
## Data from Husi 2022
loire <- data.frame(
  lower = c(625, 700, 1200, 1225, 1250, 500, 1000, 1200,
            1325, 1375, 1200, 1300, 1375, 1275, 1325),
  upper = c(750, 825, 1250, 1275, 1325, 700, 1300, 1325,
            1400, 1500, 1300, 1375, 1500, 1325, 1425)
)

## Basic relations
allen_relation(loire$lower, loire$upper)

## Complement
(comp <- allen_complement("F")) # "pmoDseSdfOMP"

## Converse
(conv <- allen_converse(comp)) # "pmoFDseSdOMP"

## Composition
allen_composition("oFD", "oFDseS") # "pmoFD"

## Intersection
allen_intersect("pFsSf", "pmoFD") # "pF"

# Union
allen_union("pFsSf", "pmoFD") # "pmoFDsSf"
}
\references{
Allen, J. F. (1983). Maintaining Knowledge about Temporal Intervals.
\emph{Communications of the ACM}, 26(11): 832-843. \doi{10.1145/182.358434}.
}
\seealso{
Other Allen's intervals: 
\code{\link{allen_analyze}()},
\code{\link{allen_complement}()},
\code{\link{allen_converse}()},
\code{\link{allen_illustrate}()},
\code{\link{allen_intersect}()},
\code{\link{allen_joint_concurrency}()},
\code{\link{allen_observe}()},
\code{\link{allen_observe_frequency}()},
\code{\link{allen_relation}()},
\code{\link{allen_relation_code}()},
\code{\link{allen_union}()}
}
\author{
T. S. Dye, N. Frerebeau
}
\concept{Allen's intervals}
