% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_mcmc.R
\name{AM_mcmc_parameters}
\alias{AM_mcmc_parameters}
\title{MCMC Parameters}
\usage{
AM_mcmc_parameters(
  niter = 5000,
  burnin = 2500,
  thin = 1,
  verbose = 1,
  output = c("CI", "K"),
  parallel = TRUE,
  output_dir = NULL
)
}
\arguments{
\item{niter}{Total number of MCMC iterations to be carried out.}

\item{burnin}{Number of iterations to be considered as burn-in. Samples from this burn-in period are discarded.}

\item{thin}{Thinning rate. This argument specifies how often a draw from the posterior distribution is stored after
burnin, i.e. one every -th samples is saved. Therefore, the toral number of MCMC samples saved is
(\code{niter} -\code{burnin})/\code{thin}. If thin =1, then AntMAN stores every iteration.}

\item{verbose}{A value from 0 to 4, that specifies the desired level of verbosity (0:None, 1:Warnings, 2:Debug, 3:Extras).}

\item{output}{A list of parameters output to return.}

\item{parallel}{Some of the algorithms can be run in parallel using OpenMP. When set to True, this parameter triggers the parallelism.}

\item{output_dir}{Path to an output dir, where to store all the outputs.}
}
\value{
An \code{\link{AM_mcmc_configuration}} Object. This is a list to be used as \code{mcmc_parameters} argument with \code{\link{AM_mcmc_fit}}.
}
\description{
This function generates an MCMC parameters list to be used as \code{mcmc_parameters} argument within \code{\link{AM_mcmc_fit}}.
}
\examples{
AM_mcmc_parameters (niter=1000, burnin=10000, thin=50)
AM_mcmc_parameters (niter=1000, burnin=10000, thin=50, output=c("CI","W","TAU"))
}
