/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.diagnostics;

import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.processing.DiagnosticsConfiguration;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MDiagnosticsConfiguration
implements DiagnosticsConfiguration {
    private static final AtomicReference<MDiagnosticsConfiguration> DEFAULT = new AtomicReference<MDiagnosticsConfiguration>(MDiagnosticsConfiguration.builder().build());
    public static final boolean ACTIVE = true;
    public static final boolean ALL = true;
    private final boolean active;
    public static final double SEVERE = 2.0;
    public static final double BAD = 1.0;
    private final double severeThreshold;
    private final double badThreshold;
    private final boolean all;

    public static void setDefault(MDiagnosticsConfiguration config) {
        DEFAULT.set(config);
    }

    public static MDiagnosticsConfiguration getDefault() {
        return DEFAULT.get();
    }

    public void check() {
        if (this.badThreshold > this.severeThreshold || this.badThreshold < 0.0 || this.severeThreshold > 3.0) {
            throw new IllegalArgumentException("Invalid settings in M-diagnostics");
        }
    }

    public static Builder builder() {
        return new Builder().active(true).badThreshold(1.0).severeThreshold(2.0).all(true);
    }

    public DiagnosticsConfiguration activate(boolean active) {
        if (this.active == active) {
            return this;
        }
        return this.toBuilder().active(active).build();
    }

    @Generated
    MDiagnosticsConfiguration(boolean active, double severeThreshold, double badThreshold, boolean all) {
        this.active = active;
        this.severeThreshold = severeThreshold;
        this.badThreshold = badThreshold;
        this.all = all;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().active(this.active).severeThreshold(this.severeThreshold).badThreshold(this.badThreshold).all(this.all);
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public double getSevereThreshold() {
        return this.severeThreshold;
    }

    @Generated
    public double getBadThreshold() {
        return this.badThreshold;
    }

    @Generated
    public boolean isAll() {
        return this.all;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MDiagnosticsConfiguration)) {
            return false;
        }
        MDiagnosticsConfiguration other = (MDiagnosticsConfiguration)o;
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (Double.compare(this.getSevereThreshold(), other.getSevereThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getBadThreshold(), other.getBadThreshold()) != 0) {
            return false;
        }
        return this.isAll() == other.isAll();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        long $severeThreshold = Double.doubleToLongBits(this.getSevereThreshold());
        result = result * 59 + (int)($severeThreshold >>> 32 ^ $severeThreshold);
        long $badThreshold = Double.doubleToLongBits(this.getBadThreshold());
        result = result * 59 + (int)($badThreshold >>> 32 ^ $badThreshold);
        result = result * 59 + (this.isAll() ? 79 : 97);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "MDiagnosticsConfiguration(active=" + this.isActive() + ", severeThreshold=" + this.getSevereThreshold() + ", badThreshold=" + this.getBadThreshold() + ", all=" + this.isAll() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean active;
        @Generated
        private double severeThreshold;
        @Generated
        private double badThreshold;
        @Generated
        private boolean all;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public @NonNull Builder severeThreshold(double severeThreshold) {
            this.severeThreshold = severeThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder badThreshold(double badThreshold) {
            this.badThreshold = badThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder all(boolean all) {
            this.all = all;
            return this;
        }

        @Generated
        public @NonNull MDiagnosticsConfiguration build() {
            return new MDiagnosticsConfiguration(this.active, this.severeThreshold, this.badThreshold, this.all);
        }

        @Generated
        public @NonNull String toString() {
            return "MDiagnosticsConfiguration.Builder(active=" + this.active + ", severeThreshold=" + this.severeThreshold + ", badThreshold=" + this.badThreshold + ", all=" + this.all + ")";
        }
    }
}

