/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.memory.structure.IndexedObject;
import choco.kernel.memory.structure.iterators.BipartiteSetIterator;
import choco.kernel.solver.SolverException;
import java.util.ArrayList;

public class StoredIndexedBipartiteSet
implements IStateIntVector {
    protected int[] list;
    protected int[] position;
    private IndexedObject[] idxToObjects;
    protected IStateInt last;
    protected BipartiteSetIterator _iterator;

    public StoredIndexedBipartiteSet(IEnvironment environment, int[] values) {
        this.buildList(environment, values);
    }

    public StoredIndexedBipartiteSet(IEnvironment environment, IndexedObject[] values) {
        int i;
        int[] intvalues = new int[values.length];
        for (i = 0; i < intvalues.length; ++i) {
            intvalues[i] = values[i].getObjectIdx();
        }
        this.buildList(environment, intvalues);
        this.idxToObjects = new IndexedObject[this.position.length];
        for (i = 0; i < intvalues.length; ++i) {
            this.idxToObjects[values[i].getObjectIdx()] = values[i];
        }
    }

    public StoredIndexedBipartiteSet(IEnvironment environment, ArrayList<IndexedObject> values) {
        int i;
        int[] intvalues = new int[values.size()];
        for (i = 0; i < intvalues.length; ++i) {
            intvalues[i] = values.get(i).getObjectIdx();
        }
        this.buildList(environment, intvalues);
        this.idxToObjects = new IndexedObject[this.position.length];
        for (i = 0; i < intvalues.length; ++i) {
            this.idxToObjects[values.get((int)i).getObjectIdx()] = values.get(i);
        }
    }

    public void buildList(IEnvironment environment, int[] values) {
        int i;
        this.list = values;
        int maxElt = 0;
        for (i = 0; i < values.length; ++i) {
            if (values[i] <= maxElt) continue;
            maxElt = values[i];
        }
        this.position = new int[maxElt + 1];
        for (i = 0; i < values.length; ++i) {
            this.position[values[i]] = i;
        }
        this.last = environment.makeInt(this.list.length - 1);
    }

    public StoredIndexedBipartiteSet(IEnvironment environment, int nbValues) {
        int[] values = new int[nbValues];
        for (int i = 0; i < nbValues; ++i) {
            values[i] = i;
        }
        this.buildList(environment, values);
    }

    public final void increaseSize(int gap) {
        int l = this.list.length;
        int[] newList = new int[l + gap];
        for (int i = 0; i < l + gap; ++i) {
            newList[i] = i;
        }
        int maxElt = 0;
        for (int i = 0; i < newList.length; ++i) {
            if (newList[i] <= maxElt) continue;
            maxElt = newList[i];
        }
        int[] newPosition = new int[maxElt + 1];
        for (int i = 0; i < newList.length; ++i) {
            newPosition[newList[i]] = i;
        }
        int end = this.last.get() + 1;
        int[] removed = new int[this.list.length - end];
        System.arraycopy(this.list, end, removed, 0, this.list.length - end);
        this.list = newList;
        this.position = newPosition;
        IEnvironment env = this.last.getEnvironment();
        this.last = null;
        this.last = env.makeInt(this.list.length - 1);
        for (int i = 0; i < removed.length; ++i) {
            this.remove(removed[i]);
        }
    }

    @Override
    public final int size() {
        return this.last.get() + 1;
    }

    @Override
    public final boolean isEmpty() {
        return this.last.get() == -1;
    }

    @Override
    public final void add(int i) {
        throw new UnsupportedOperationException("adding element is not permitted in this structure (the list is only meant to decrease during search)");
    }

    public final void clear() {
        this.last.set(-1);
    }

    @Override
    public final void removeLast() {
        this.remove(this.list[this.last.get()]);
    }

    @Override
    public void remove(int object) {
        if (this.contain(object)) {
            int idxToRem = this.position[object];
            if (idxToRem == this.last.get()) {
                this.last.add(-1);
            } else {
                int temp = this.list[this.last.get()];
                this.list[this.last.get()] = object;
                this.list[idxToRem] = temp;
                this.position[object] = this.last.get();
                this.position[temp] = idxToRem;
                this.last.add(-1);
            }
        }
    }

    public final void remove(IndexedObject object) {
        this.remove(object.getObjectIdx());
    }

    @Override
    public boolean contain(int object) {
        return this.position[object] <= this.last.get();
    }

    public final boolean contain(IndexedObject object) {
        return this.contain(object.getObjectIdx());
    }

    @Override
    public final int get(int index) {
        return this.list[index];
    }

    @Override
    public final int quickGet(int index) {
        return this.get(index);
    }

    public final IndexedObject getObject(int index) {
        return this.idxToObjects[this.list[index]];
    }

    @Override
    public final int set(int index, int val) {
        throw new SolverException("setting an element is not permitted on this structure");
    }

    @Override
    public final int quickSet(int index, int val) {
        return this.set(index, val);
    }

    @Override
    public final DisposableIntIterator getIterator() {
        if (this._iterator == null || !this._iterator.reusable()) {
            this._iterator = new BipartiteSetIterator();
        }
        this._iterator.init(this.list, this.position, this.last, this.idxToObjects);
        return this._iterator;
    }

    public final BipartiteSetIterator getObjectIterator() {
        if (this._iterator == null || !this._iterator.reusable()) {
            this._iterator = new BipartiteSetIterator();
        }
        this._iterator.init(this.list, this.position, this.last, this.idxToObjects);
        return this._iterator;
    }

    public final String pretty() {
        StringBuilder s = new StringBuilder("[");
        for (int i = 0; i <= this.last.get(); ++i) {
            s.append(this.list[i]).append(i == this.last.get() ? "" : ",");
        }
        return s.append(']').toString();
    }

    public final int findIndexOfInt(int a) {
        return this.list.length - this.position[a];
    }

    public final int[] _getStructure() {
        return this.list;
    }
}

