/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramoseats;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.sa.base.api.StationaryVarianceDecomposition;
import jdplus.sa.base.core.StationaryVarianceComputer;
import jdplus.sa.base.core.diagnostics.GenericSaTests;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.tramoseats.base.core.seats.SeatsResults;
import jdplus.tramoseats.base.core.seats.SeatsTests;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class TramoSeatsDiagnostics {
    private final StationaryVarianceDecomposition varianceDecomposition;
    private final GenericSaTests genericDiagnostics;
    private final SeatsTests specificDiagnostics;

    public static TramoSeatsDiagnostics of(RegSarimaModel preprocessing, SeatsResults srslts, SeriesDecomposition finals) {
        boolean mul = preprocessing.getDescription().isLogTransformation();
        TsData sa = srslts.getFinalComponents().getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
        TsData i = srslts.getFinalComponents().getSeries(ComponentType.Irregular, ComponentInformation.Value);
        TsData s = srslts.getFinalComponents().getSeries(ComponentType.Seasonal, ComponentInformation.Value);
        TsData si = mul ? TsData.multiply((TsData)s, (TsData[])new TsData[]{i}) : TsData.add((TsData)s, (TsData)i);
        TsData lsa = srslts.getInitialComponents().getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
        TsData li = srslts.getInitialComponents().getSeries(ComponentType.Irregular, ComponentInformation.Value);
        TsData lin = preprocessing.linearizedSeries();
        TsData y = preprocessing.backTransform(lin, false);
        GenericSaTests gsadiags = GenericSaTests.builder().mul(mul).regarima(preprocessing).lin(lin).res(preprocessing.fullResiduals()).y(y).sa(sa).irr(i).si(si).lsa(lsa).lirr(li).build();
        SeatsTests st = new SeatsTests(srslts);
        return new TramoSeatsDiagnostics(TramoSeatsDiagnostics.varDecomposition(preprocessing, srslts), gsadiags, st);
    }

    private static StationaryVarianceDecomposition varDecomposition(RegSarimaModel preprocessing, SeatsResults srslts) {
        TsData others;
        StationaryVarianceComputer var = new StationaryVarianceComputer(StationaryVarianceComputer.HP);
        boolean mul = preprocessing.getDescription().isLogTransformation();
        TsData y = preprocessing.interpolatedSeries(false);
        TsData t = srslts.getFinalComponents().getSeries(ComponentType.Trend, ComponentInformation.Value);
        TsData seas = srslts.getFinalComponents().getSeries(ComponentType.Seasonal, ComponentInformation.Value);
        TsData irr = srslts.getFinalComponents().getSeries(ComponentType.Irregular, ComponentInformation.Value);
        TsData cal = preprocessing.getCalendarEffect(y.getDomain());
        if (mul) {
            TsData all = TsData.multiply((TsData)t, (TsData[])new TsData[]{seas, irr, cal});
            others = TsData.divide((TsData)y, (TsData)all);
        } else {
            TsData all = TsData.add((TsData)t, (TsData[])new TsData[]{seas, irr, cal});
            others = TsData.subtract((TsData)y, (TsData)all);
        }
        return var.build(y, t, seas, irr, cal, others, mul);
    }

    @Generated
    public StationaryVarianceDecomposition getVarianceDecomposition() {
        return this.varianceDecomposition;
    }

    @Generated
    public GenericSaTests getGenericDiagnostics() {
        return this.genericDiagnostics;
    }

    @Generated
    public SeatsTests getSpecificDiagnostics() {
        return this.specificDiagnostics;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TramoSeatsDiagnostics)) {
            return false;
        }
        TramoSeatsDiagnostics other = (TramoSeatsDiagnostics)o;
        StationaryVarianceDecomposition this$varianceDecomposition = this.getVarianceDecomposition();
        StationaryVarianceDecomposition other$varianceDecomposition = other.getVarianceDecomposition();
        if (this$varianceDecomposition == null ? other$varianceDecomposition != null : !this$varianceDecomposition.equals(other$varianceDecomposition)) {
            return false;
        }
        GenericSaTests this$genericDiagnostics = this.getGenericDiagnostics();
        GenericSaTests other$genericDiagnostics = other.getGenericDiagnostics();
        if (this$genericDiagnostics == null ? other$genericDiagnostics != null : !this$genericDiagnostics.equals(other$genericDiagnostics)) {
            return false;
        }
        SeatsTests this$specificDiagnostics = this.getSpecificDiagnostics();
        SeatsTests other$specificDiagnostics = other.getSpecificDiagnostics();
        return !(this$specificDiagnostics == null ? other$specificDiagnostics != null : !this$specificDiagnostics.equals(other$specificDiagnostics));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StationaryVarianceDecomposition $varianceDecomposition = this.getVarianceDecomposition();
        result = result * 59 + ($varianceDecomposition == null ? 43 : $varianceDecomposition.hashCode());
        GenericSaTests $genericDiagnostics = this.getGenericDiagnostics();
        result = result * 59 + ($genericDiagnostics == null ? 43 : $genericDiagnostics.hashCode());
        SeatsTests $specificDiagnostics = this.getSpecificDiagnostics();
        result = result * 59 + ($specificDiagnostics == null ? 43 : $specificDiagnostics.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "TramoSeatsDiagnostics(varianceDecomposition=" + String.valueOf(this.getVarianceDecomposition()) + ", genericDiagnostics=" + String.valueOf(this.getGenericDiagnostics()) + ", specificDiagnostics=" + String.valueOf(this.getSpecificDiagnostics()) + ")";
    }

    @Generated
    private TramoSeatsDiagnostics(StationaryVarianceDecomposition varianceDecomposition, GenericSaTests genericDiagnostics, SeatsTests specificDiagnostics) {
        this.varianceDecomposition = varianceDecomposition;
        this.genericDiagnostics = genericDiagnostics;
        this.specificDiagnostics = specificDiagnostics;
    }
}

