/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaToolkit;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.regsarima.regular.SeasonalityDetector;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.tramoseats.base.api.seats.SeatsModelSpec;
import jdplus.tramoseats.base.core.tramo.TramoSeasonalityDetector;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SeatsModel {
    private final TsData originalSeries;
    private final TsData transformedSeries;
    private final boolean logTransformation;
    private final SarimaModel originalModel;
    private final boolean significantSeasonality;
    private boolean meanCorrection;
    private SarimaModel currentModel;
    private boolean parametersCutOff;
    private boolean modelChanged;
    private UcarimaModel ucarimaModel;
    private SeriesDecomposition initialComponents;
    private SeriesDecomposition finalComponents;
    private double innovationVariance;

    public static SeatsModel of(SeatsModelSpec spec) {
        SeatsModel model = !spec.getSarimaSpec().isDefined() ? SeatsModel.buildEstimatedModel(spec) : SeatsModel.buildDefinedModel(spec);
        return model;
    }

    private static SeatsModel buildDefinedModel(SeatsModelSpec spec) {
        TsData series = spec.getSeries();
        int period = series.getAnnualFrequency();
        boolean log = spec.isLog();
        TsData nseries = log ? series.log() : series;
        boolean mean = spec.isMeanCorrection();
        SarimaSpec sarimaSpec = spec.getSarimaSpec().withPeriod(period);
        SarimaOrders orders = sarimaSpec.orders();
        SarimaModel sarima = SarimaModel.builder((SarimaOrders)orders).phi(Parameter.values((Parameter[])sarimaSpec.getPhi())).bphi(Parameter.values((Parameter[])sarimaSpec.getBphi())).theta(Parameter.values((Parameter[])sarimaSpec.getTheta())).btheta(Parameter.values((Parameter[])sarimaSpec.getBtheta())).build();
        TramoSeasonalityDetector detector = new TramoSeasonalityDetector();
        SeasonalityDetector.Seasonality seas = detector.hasSeasonality(nseries.getValues(), period);
        SeatsModel seatsModel = new SeatsModel(series, nseries, log, sarima, seas.toInt() > 1);
        seatsModel.meanCorrection = mean;
        double var = spec.getInnovationVariance();
        if (var == 0.0) {
            RegArimaModel regarima = RegArimaModel.builder().y(nseries.getValues()).arima((IArimaModel)sarima).meanCorrection(mean).build();
            ConcentratedLikelihoodWithMissing ll = ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(regarima);
            var = ll.ssq() / (double)(ll.dim() - orders.getParametersCount());
        }
        seatsModel.innovationVariance = var;
        return seatsModel;
    }

    private static SeatsModel buildEstimatedModel(SeatsModelSpec spec) {
        TsData series = spec.getSeries();
        int period = series.getAnnualFrequency();
        boolean log = spec.isLog();
        TsData nseries = log ? series.log() : series;
        boolean mean = spec.isMeanCorrection();
        SarimaSpec sarimaSpec = spec.getSarimaSpec().withPeriod(period);
        if (sarimaSpec.hasFixedParameters()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        SarimaOrders orders = sarimaSpec.orders();
        SarimaModel sarima = SarimaModel.builder((SarimaOrders)orders).phi(Parameter.values((Parameter[])sarimaSpec.getPhi())).bphi(Parameter.values((Parameter[])sarimaSpec.getBphi())).theta(Parameter.values((Parameter[])sarimaSpec.getTheta())).btheta(Parameter.values((Parameter[])sarimaSpec.getBtheta())).build();
        RegArimaModel regarima = RegArimaModel.builder().y(nseries.getValues()).arima((IArimaModel)sarima).meanCorrection(mean).build();
        RegArimaEstimation estimation = RegArimaToolkit.robustEstimation((RegArimaModel)regarima, null);
        SarimaModel arima = (SarimaModel)estimation.getModel().arima();
        LikelihoodStatistics stat = estimation.statistics();
        double var = stat.getSsqErr() / (double)(stat.getEffectiveObservationsCount() - stat.getEstimatedParametersCount());
        TramoSeasonalityDetector detector = new TramoSeasonalityDetector();
        SeasonalityDetector.Seasonality seas = detector.hasSeasonality(nseries.getValues(), period);
        SeatsModel seatsModel = new SeatsModel(series, nseries, log, arima, seas.toInt() > 1);
        seatsModel.meanCorrection = mean;
        seatsModel.innovationVariance = var;
        return seatsModel;
    }

    public RegArimaModel<SarimaModel> asRegarima() {
        return RegArimaModel.builder().y(this.transformedSeries.getValues()).arima((IArimaModel)this.currentModel).meanCorrection(this.meanCorrection).build();
    }

    public double defaultInnovation(boolean set) {
        RegArimaModel regarima = RegArimaModel.builder().y(this.transformedSeries.getValues()).arima((IArimaModel)this.currentModel).meanCorrection(this.meanCorrection).build();
        RegArimaEstimation estimation = RegArimaToolkit.concentratedLikelihood((RegArimaModel)regarima);
        LikelihoodStatistics stat = estimation.statistics();
        double var = stat.getSsqErr() / (double)(stat.getEffectiveObservationsCount() - stat.getEstimatedParametersCount());
        if (set) {
            this.innovationVariance = var;
        }
        return var;
    }

    public int getPeriod() {
        return this.originalModel.getPeriod();
    }

    public int extrapolationCount(int nf) {
        if (nf < 0) {
            return -this.getPeriod() * nf;
        }
        return nf;
    }

    public UcarimaModel compactUcarimaModel(boolean mean, boolean clean) {
        if (this.ucarimaModel == null) {
            return null;
        }
        UcarimaModel ucm = this.ucarimaModel;
        if (mean && this.meanCorrection) {
            UcarimaModel.Builder tmp = UcarimaModel.builder();
            ArimaModel tm = ucm.getComponent(0);
            tm = tm.isNull() ? new ArimaModel(BackFilter.ONE, BackFilter.D1, BackFilter.D1, 0.0) : new ArimaModel(tm.getStationaryAr(), tm.getNonStationaryAr().times(BackFilter.D1), tm.getMa().times(BackFilter.D1), tm.getInnovationVariance());
            tmp.add(tm);
            for (int i = 1; i < ucm.getComponentsCount(); ++i) {
                tmp.add(ucm.getComponent(i));
            }
            ucm = tmp.build();
        }
        if (ucm.getComponentsCount() > 3) {
            ucm = ucm.compact(2, 2);
        }
        return clean ? ucm.simplify() : ucm;
    }

    public ComponentType[] componentsType() {
        if (this.ucarimaModel == null) {
            return null;
        }
        boolean hast = !this.ucarimaModel.getComponent(0).isNull() || this.meanCorrection;
        boolean hass = !this.ucarimaModel.getComponent(1).isNull();
        boolean hastr = !this.ucarimaModel.getComponent(2).isNull();
        boolean hasirr = hastr || !this.ucarimaModel.getComponent(3).isNull();
        int ncmps = (hast ? 1 : 0) + (hass ? 1 : 0) + (hasirr ? 1 : 0);
        ComponentType[] cmps = new ComponentType[ncmps];
        int icmp = 0;
        if (hast) {
            cmps[icmp++] = ComponentType.Trend;
        }
        if (hass) {
            cmps[icmp++] = ComponentType.Seasonal;
        }
        if (hasirr) {
            cmps[icmp++] = ComponentType.Irregular;
        }
        return cmps;
    }

    @Generated
    public SeatsModel(TsData originalSeries, TsData transformedSeries, boolean logTransformation, SarimaModel originalModel, boolean significantSeasonality) {
        this.originalSeries = originalSeries;
        this.transformedSeries = transformedSeries;
        this.logTransformation = logTransformation;
        this.originalModel = originalModel;
        this.significantSeasonality = significantSeasonality;
    }

    @Generated
    public TsData getOriginalSeries() {
        return this.originalSeries;
    }

    @Generated
    public TsData getTransformedSeries() {
        return this.transformedSeries;
    }

    @Generated
    public boolean isLogTransformation() {
        return this.logTransformation;
    }

    @Generated
    public SarimaModel getOriginalModel() {
        return this.originalModel;
    }

    @Generated
    public boolean isSignificantSeasonality() {
        return this.significantSeasonality;
    }

    @Generated
    public boolean isMeanCorrection() {
        return this.meanCorrection;
    }

    @Generated
    public SarimaModel getCurrentModel() {
        return this.currentModel;
    }

    @Generated
    public boolean isParametersCutOff() {
        return this.parametersCutOff;
    }

    @Generated
    public boolean isModelChanged() {
        return this.modelChanged;
    }

    @Generated
    public UcarimaModel getUcarimaModel() {
        return this.ucarimaModel;
    }

    @Generated
    public SeriesDecomposition getInitialComponents() {
        return this.initialComponents;
    }

    @Generated
    public SeriesDecomposition getFinalComponents() {
        return this.finalComponents;
    }

    @Generated
    public double getInnovationVariance() {
        return this.innovationVariance;
    }

    @Generated
    public void setMeanCorrection(boolean meanCorrection) {
        this.meanCorrection = meanCorrection;
    }

    @Generated
    public void setCurrentModel(SarimaModel currentModel) {
        this.currentModel = currentModel;
    }

    @Generated
    public void setParametersCutOff(boolean parametersCutOff) {
        this.parametersCutOff = parametersCutOff;
    }

    @Generated
    public void setModelChanged(boolean modelChanged) {
        this.modelChanged = modelChanged;
    }

    @Generated
    public void setUcarimaModel(UcarimaModel ucarimaModel) {
        this.ucarimaModel = ucarimaModel;
    }

    @Generated
    public void setInitialComponents(SeriesDecomposition initialComponents) {
        this.initialComponents = initialComponents;
    }

    @Generated
    public void setFinalComponents(SeriesDecomposition finalComponents) {
        this.finalComponents = finalComponents;
    }

    @Generated
    public void setInnovationVariance(double innovationVariance) {
        this.innovationVariance = innovationVariance;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeatsModel)) {
            return false;
        }
        SeatsModel other = (SeatsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLogTransformation() != other.isLogTransformation()) {
            return false;
        }
        if (this.isSignificantSeasonality() != other.isSignificantSeasonality()) {
            return false;
        }
        if (this.isMeanCorrection() != other.isMeanCorrection()) {
            return false;
        }
        if (this.isParametersCutOff() != other.isParametersCutOff()) {
            return false;
        }
        if (this.isModelChanged() != other.isModelChanged()) {
            return false;
        }
        if (Double.compare(this.getInnovationVariance(), other.getInnovationVariance()) != 0) {
            return false;
        }
        TsData this$originalSeries = this.getOriginalSeries();
        TsData other$originalSeries = other.getOriginalSeries();
        if (this$originalSeries == null ? other$originalSeries != null : !this$originalSeries.equals(other$originalSeries)) {
            return false;
        }
        TsData this$transformedSeries = this.getTransformedSeries();
        TsData other$transformedSeries = other.getTransformedSeries();
        if (this$transformedSeries == null ? other$transformedSeries != null : !this$transformedSeries.equals(other$transformedSeries)) {
            return false;
        }
        SarimaModel this$originalModel = this.getOriginalModel();
        SarimaModel other$originalModel = other.getOriginalModel();
        if (this$originalModel == null ? other$originalModel != null : !this$originalModel.equals(other$originalModel)) {
            return false;
        }
        SarimaModel this$currentModel = this.getCurrentModel();
        SarimaModel other$currentModel = other.getCurrentModel();
        if (this$currentModel == null ? other$currentModel != null : !this$currentModel.equals(other$currentModel)) {
            return false;
        }
        UcarimaModel this$ucarimaModel = this.getUcarimaModel();
        UcarimaModel other$ucarimaModel = other.getUcarimaModel();
        if (this$ucarimaModel == null ? other$ucarimaModel != null : !this$ucarimaModel.equals(other$ucarimaModel)) {
            return false;
        }
        SeriesDecomposition this$initialComponents = this.getInitialComponents();
        SeriesDecomposition other$initialComponents = other.getInitialComponents();
        if (this$initialComponents == null ? other$initialComponents != null : !this$initialComponents.equals(other$initialComponents)) {
            return false;
        }
        SeriesDecomposition this$finalComponents = this.getFinalComponents();
        SeriesDecomposition other$finalComponents = other.getFinalComponents();
        return !(this$finalComponents == null ? other$finalComponents != null : !this$finalComponents.equals(other$finalComponents));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SeatsModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLogTransformation() ? 79 : 97);
        result = result * 59 + (this.isSignificantSeasonality() ? 79 : 97);
        result = result * 59 + (this.isMeanCorrection() ? 79 : 97);
        result = result * 59 + (this.isParametersCutOff() ? 79 : 97);
        result = result * 59 + (this.isModelChanged() ? 79 : 97);
        long $innovationVariance = Double.doubleToLongBits(this.getInnovationVariance());
        result = result * 59 + (int)($innovationVariance >>> 32 ^ $innovationVariance);
        TsData $originalSeries = this.getOriginalSeries();
        result = result * 59 + ($originalSeries == null ? 43 : $originalSeries.hashCode());
        TsData $transformedSeries = this.getTransformedSeries();
        result = result * 59 + ($transformedSeries == null ? 43 : $transformedSeries.hashCode());
        SarimaModel $originalModel = this.getOriginalModel();
        result = result * 59 + ($originalModel == null ? 43 : $originalModel.hashCode());
        SarimaModel $currentModel = this.getCurrentModel();
        result = result * 59 + ($currentModel == null ? 43 : $currentModel.hashCode());
        UcarimaModel $ucarimaModel = this.getUcarimaModel();
        result = result * 59 + ($ucarimaModel == null ? 43 : $ucarimaModel.hashCode());
        SeriesDecomposition $initialComponents = this.getInitialComponents();
        result = result * 59 + ($initialComponents == null ? 43 : $initialComponents.hashCode());
        SeriesDecomposition $finalComponents = this.getFinalComponents();
        result = result * 59 + ($finalComponents == null ? 43 : $finalComponents.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SeatsModel(originalSeries=" + String.valueOf(this.getOriginalSeries()) + ", transformedSeries=" + String.valueOf(this.getTransformedSeries()) + ", logTransformation=" + this.isLogTransformation() + ", originalModel=" + String.valueOf(this.getOriginalModel()) + ", significantSeasonality=" + this.isSignificantSeasonality() + ", meanCorrection=" + this.isMeanCorrection() + ", currentModel=" + String.valueOf(this.getCurrentModel()) + ", parametersCutOff=" + this.isParametersCutOff() + ", modelChanged=" + this.isModelChanged() + ", ucarimaModel=" + String.valueOf(this.getUcarimaModel()) + ", initialComponents=" + String.valueOf(this.getInitialComponents()) + ", finalComponents=" + String.valueOf(this.getFinalComponents()) + ", innovationVariance=" + this.getInnovationVariance() + ")";
    }
}

