/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.data.Range;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.regression.ISystemVariable;
import jdplus.toolkit.base.api.timeseries.regression.IUserVariable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class InterventionVariable
implements IUserVariable,
ISystemVariable {
    private final double delta;
    private final double deltaSeasonal;
    private final List<Range<LocalDateTime>> sequences;
    private static final InterventionVariable EMPTY = new Builder().build();

    @Override
    public int dim() {
        return 1;
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        return "iv";
    }

    public static InterventionVariable empty() {
        return EMPTY;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().delta(this.delta).deltaSeasonal(this.deltaSeasonal);
        if (this.sequences != null) {
            builder.sequences(this.sequences);
        }
        return builder;
    }

    @Generated
    public double getDelta() {
        return this.delta;
    }

    @Generated
    public double getDeltaSeasonal() {
        return this.deltaSeasonal;
    }

    @Generated
    public List<Range<LocalDateTime>> getSequences() {
        return this.sequences;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InterventionVariable)) {
            return false;
        }
        InterventionVariable other = (InterventionVariable)o;
        if (Double.compare(this.getDelta(), other.getDelta()) != 0) {
            return false;
        }
        if (Double.compare(this.getDeltaSeasonal(), other.getDeltaSeasonal()) != 0) {
            return false;
        }
        List<Range<LocalDateTime>> this$sequences = this.getSequences();
        List<Range<LocalDateTime>> other$sequences = other.getSequences();
        return !(this$sequences == null ? other$sequences != null : !((Object)this$sequences).equals(other$sequences));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $delta = Double.doubleToLongBits(this.getDelta());
        result = result * 59 + (int)($delta >>> 32 ^ $delta);
        long $deltaSeasonal = Double.doubleToLongBits(this.getDeltaSeasonal());
        result = result * 59 + (int)($deltaSeasonal >>> 32 ^ $deltaSeasonal);
        List<Range<LocalDateTime>> $sequences = this.getSequences();
        result = result * 59 + ($sequences == null ? 43 : ((Object)$sequences).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "InterventionVariable(delta=" + this.getDelta() + ", deltaSeasonal=" + this.getDeltaSeasonal() + ", sequences=" + String.valueOf(this.getSequences()) + ")";
    }

    @Generated
    private InterventionVariable(double delta, double deltaSeasonal, List<Range<LocalDateTime>> sequences) {
        this.delta = delta;
        this.deltaSeasonal = deltaSeasonal;
        this.sequences = sequences;
    }

    @Generated
    public static class Builder {
        @Generated
        private double delta;
        @Generated
        private double deltaSeasonal;
        @Generated
        private ArrayList<Range<LocalDateTime>> sequences;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder delta(double delta) {
            this.delta = delta;
            return this;
        }

        @Generated
        public @NonNull Builder deltaSeasonal(double deltaSeasonal) {
            this.deltaSeasonal = deltaSeasonal;
            return this;
        }

        @Generated
        public @NonNull Builder sequence(Range<LocalDateTime> sequence) {
            if (this.sequences == null) {
                this.sequences = new ArrayList();
            }
            this.sequences.add(sequence);
            return this;
        }

        @Generated
        public @NonNull Builder sequences(@NonNull Collection<? extends Range<LocalDateTime>> sequences) {
            if (sequences == null) {
                throw new NullPointerException("sequences cannot be null");
            }
            if (this.sequences == null) {
                this.sequences = new ArrayList();
            }
            this.sequences.addAll(sequences);
            return this;
        }

        @Generated
        public @NonNull Builder clearSequences() {
            if (this.sequences != null) {
                this.sequences.clear();
            }
            return this;
        }

        @Generated
        public @NonNull InterventionVariable build() {
            return new InterventionVariable(this.delta, this.deltaSeasonal, switch (this.sequences == null ? 0 : this.sequences.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.sequences.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Range<LocalDateTime>>(this.sequences));
            });
        }

        @Generated
        public @NonNull String toString() {
            return "InterventionVariable.Builder(delta=" + this.delta + ", deltaSeasonal=" + this.deltaSeasonal + ", sequences=" + String.valueOf(this.sequences) + ")";
        }
    }
}

