/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.util.Arrays;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.calendars.Calendar;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarDefinition;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import jdplus.toolkit.base.api.timeseries.calendars.HolidaysOption;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class HolidaysVariable
implements ITradingDaysVariable {
    public static final int[] NONWORKING_WE = new int[]{6, 7};
    public static final int[] NONWORKING_SUNDAYS = new int[]{7};
    private final Holiday[] holidays;
    private final HolidaysOption holidaysOption;
    private final boolean single;
    private final int[] nonworking;

    public static HolidaysVariable of(String name, HolidaysOption holidaysOption, int[] nonworking, boolean single, ModellingContext context) {
        CalendarDefinition cdef = (CalendarDefinition)context.getCalendars().get(name);
        if (!(cdef instanceof Calendar)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        Calendar c = (Calendar)cdef;
        return new HolidaysVariable(c.getHolidays(), holidaysOption, single, nonworking);
    }

    @Override
    public int dim() {
        return this.single ? 1 : this.holidays.length;
    }

    @Override
    public TradingDaysType getTradingDaysType() {
        return TradingDaysType.TDuser;
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        return "holidays";
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(int idx, D context) {
        return this.single ? "holidays" : this.holidays[idx].display();
    }

    @Generated
    public HolidaysVariable(Holiday[] holidays, HolidaysOption holidaysOption, boolean single, int[] nonworking) {
        this.holidays = holidays;
        this.holidaysOption = holidaysOption;
        this.single = single;
        this.nonworking = nonworking;
    }

    @Generated
    public Holiday[] getHolidays() {
        return this.holidays;
    }

    @Generated
    public HolidaysOption getHolidaysOption() {
        return this.holidaysOption;
    }

    @Generated
    public boolean isSingle() {
        return this.single;
    }

    @Generated
    public int[] getNonworking() {
        return this.nonworking;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HolidaysVariable)) {
            return false;
        }
        HolidaysVariable other = (HolidaysVariable)o;
        if (this.isSingle() != other.isSingle()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHolidays(), other.getHolidays())) {
            return false;
        }
        HolidaysOption this$holidaysOption = this.getHolidaysOption();
        HolidaysOption other$holidaysOption = other.getHolidaysOption();
        if (this$holidaysOption == null ? other$holidaysOption != null : !((Object)((Object)this$holidaysOption)).equals((Object)other$holidaysOption)) {
            return false;
        }
        return Arrays.equals(this.getNonworking(), other.getNonworking());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSingle() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getHolidays());
        HolidaysOption $holidaysOption = this.getHolidaysOption();
        result = result * 59 + ($holidaysOption == null ? 43 : ((Object)((Object)$holidaysOption)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getNonworking());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "HolidaysVariable(holidays=" + Arrays.deepToString(this.getHolidays()) + ", holidaysOption=" + String.valueOf((Object)this.getHolidaysOption()) + ", single=" + this.isSingle() + ", nonworking=" + Arrays.toString(this.getNonworking()) + ")";
    }
}

