/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats;

import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.stats.Kernel;
import lombok.Generated;

public final class Kernels {
    public static Kernel UNIFORM = new Kernel(){

        @Override
        public double lowerBound() {
            return -1.0;
        }

        @Override
        public double upperBound() {
            return 1.0;
        }

        @Override
        public DoubleUnaryOperator asFunction() {
            return x -> 0.5;
        }

        @Override
        public double moment(int order) {
            if (order % 2 == 1) {
                return 0.0;
            }
            return 1.0 / (double)(order + 1);
        }
    };
    public static Kernel TRIANGULAR = new Kernel(){

        @Override
        public double lowerBound() {
            return -1.0;
        }

        @Override
        public double upperBound() {
            return 1.0;
        }

        @Override
        public DoubleUnaryOperator asFunction() {
            return x -> 1.0 - Math.abs(x);
        }

        @Override
        public double moment(int order) {
            if (order % 2 == 1) {
                return 0.0;
            }
            int d = (order + 1) * (order + 2);
            return 2.0 / (double)d;
        }
    };
    public static Kernel EPANECHNIKOV = new Kernel(){

        @Override
        public double lowerBound() {
            return -1.0;
        }

        @Override
        public double upperBound() {
            return 1.0;
        }

        @Override
        public DoubleUnaryOperator asFunction() {
            return x -> 0.75 * (1.0 - x * x);
        }

        @Override
        public double moment(int order) {
            if (order % 2 == 1) {
                return 0.0;
            }
            int d = (order + 1) * (order + 3);
            return 3.0 / (double)d;
        }
    };
    public static Kernel BIWEIGHT = new Kernel(){

        @Override
        public double lowerBound() {
            return -1.0;
        }

        @Override
        public double upperBound() {
            return 1.0;
        }

        @Override
        public DoubleUnaryOperator asFunction() {
            return x -> {
                double z = 1.0 - x * x;
                return 0.9375 * z * z;
            };
        }

        @Override
        public double moment(int order) {
            if (order % 2 == 1) {
                return 0.0;
            }
            int d = (order + 1) * (order + 3) * (order + 5);
            return 15.0 / (double)d;
        }
    };
    public static Kernel TRIWEIGHT = new Kernel(){

        @Override
        public double lowerBound() {
            return -1.0;
        }

        @Override
        public double upperBound() {
            return 1.0;
        }

        @Override
        public DoubleUnaryOperator asFunction() {
            return x -> {
                double z = 1.0 - x * x;
                return 1.09375 * z * z * z;
            };
        }

        @Override
        public double moment(int order) {
            if (order % 2 == 1) {
                return 0.0;
            }
            int d = (order + 1) * (order + 3) * (order + 5) * (order + 7);
            return 105.0 / (double)d;
        }
    };

    public static Polynomial epanechnikovAsPolynomial() {
        return Polynomial.of(0.75, 0.0, -0.75);
    }

    public static Polynomial biWeightAsPolynomial() {
        return Polynomial.of(0.9375, 0.0, -1.875, 0.0, 0.9375);
    }

    public static Polynomial triWeightAsPolynomial() {
        return Polynomial.of(1.09375, 0.0, -3.28125, 0.0, 3.28125, 0.0, -1.09375);
    }

    public static Kernel henderson(int length) {
        final Polynomial p = Kernels.hendersonAsPolynomial(length);
        return new Kernel(){

            @Override
            public double lowerBound() {
                return -1.0;
            }

            @Override
            public double upperBound() {
                return 1.0;
            }

            @Override
            public DoubleUnaryOperator asFunction() {
                return x -> p.evaluateAt(x);
            }

            @Override
            public double moment(int order) {
                if (order % 2 == 1) {
                    return 0.0;
                }
                double z = 0.0;
                for (int j = 0; j <= 6; j += 2) {
                    z += 2.0 * p.get(j) / (double)(1 + j + order);
                }
                return z;
            }
        };
    }

    public static Polynomial hendersonAsPolynomial(int m) {
        int q1 = (m + 1) * (m + 1);
        int q2 = (m + 2) * (m + 2);
        int q3 = (m + 3) * (m + 3);
        Polynomial p = Polynomial.of(q1 * q2 * q3, 0.0, -q1 * q1 * q2 - q1 * q1 * q3 - q1 * q2 * q3, 0.0, q1 * q1 * (q1 + q2 + q3), 0.0, -q1 * q1 * q1);
        return p.divide(p.integrate(-1.0, 1.0));
    }

    @Generated
    private Kernels() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

