/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima;

import java.util.List;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.arima.estimation.FastKalmanFilter;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regsarima.GlsSarimaComputer;
import jdplus.toolkit.base.core.regsarima.internal.HannanRissanenInitializer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import lombok.Generated;
import lombok.NonNull;

public final class RegArimaUtility {
    public static <M extends IArimaModel> DoubleSeq linearizedData(@NonNull RegArimaModel<M> model, @NonNull ConcentratedLikelihoodWithMissing concentratedLikelihood) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (concentratedLikelihood == null) {
            throw new NullPointerException("concentratedLikelihood is marked non-null but is null");
        }
        double[] res = model.getY().toArray();
        int[] missing = model.missing();
        if (missing.length > 0) {
            DoubleSeq missingEstimates = concentratedLikelihood.missingCorrections();
            for (int i = 0; i < missing.length; ++i) {
                int n = missing[i];
                res[n] = res[n] - missingEstimates.get(i);
            }
        }
        DoubleSeq b = concentratedLikelihood.coefficients();
        DataBlock e = DataBlock.of(res);
        if (b.length() > 0) {
            List<DoubleSeq> x = model.getX();
            int cur = model.isMean() ? 1 : 0;
            for (int i = 0; i < x.size(); ++i) {
                double bcur = b.get(cur++);
                e.apply(x.get(i), (u, v) -> u - bcur * v);
            }
        }
        return e;
    }

    public static <M extends IArimaModel> DoubleSeq interpolatedData(@NonNull RegArimaModel<M> model, @NonNull ConcentratedLikelihoodWithMissing concentratedLikelihood) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (concentratedLikelihood == null) {
            throw new NullPointerException("concentratedLikelihood is marked non-null but is null");
        }
        int[] missing = model.missing();
        if (missing.length == 0) {
            return model.getY();
        }
        double[] y = model.getY().toArray();
        DoubleSeqCursor reader = concentratedLikelihood.missingCorrections().cursor();
        for (int i = 0; i < missing.length; ++i) {
            int n = missing[i];
            y[n] = y[n] - reader.getAndNext();
        }
        return DoubleSeq.of((double[])y);
    }

    public static <M extends IArimaModel> DoubleSeq regressionEffect(@NonNull RegArimaModel<M> model, @NonNull ConcentratedLikelihoodWithMissing concentratedLikelihood, int startPos, int nvars) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (concentratedLikelihood == null) {
            throw new NullPointerException("concentratedLikelihood is marked non-null but is null");
        }
        DoubleSeq b = concentratedLikelihood.coefficients();
        DataBlock e = DataBlock.make(model.getObservationsCount());
        if (b.length() > 0) {
            List<DoubleSeq> x = model.getX();
            DoubleSeqCursor reader = b.cursor();
            reader.moveTo(startPos);
            int i0 = model.isMean() ? startPos - 1 : startPos;
            int i1 = i0 + nvars;
            for (int i = i0; i < i1; ++i) {
                double bcur = reader.getAndNext();
                e.apply(x.get(i), (u, v) -> u + bcur * v);
            }
        }
        return e.unmodifiable();
    }

    public static <M extends IArimaModel> DoubleSeq olsResiduals(@NonNull RegArimaModel<M> model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        LinearModel lm = model.differencedModel().asLinearModel();
        if (lm.getVariablesCount() > 0) {
            LeastSquaresResults lsr = Ols.compute(lm);
            return lm.calcResiduals(lsr.getCoefficients());
        }
        return lm.getY();
    }

    public static <M extends IArimaModel> DoubleSeq fullResiduals(@NonNull RegArimaModel<M> model, @NonNull ConcentratedLikelihoodWithMissing concentratedLikelihood) {
        DataBlock dld;
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (concentratedLikelihood == null) {
            throw new NullPointerException("concentratedLikelihood is marked non-null but is null");
        }
        if (model.getVariablesCount() == 0) {
            return concentratedLikelihood.e();
        }
        DoubleSeq ld = RegArimaUtility.linearizedData(model, concentratedLikelihood);
        StationaryTransformation st = model.arima().stationaryTransformation();
        if (st.getUnitRoots().getDegree() == 0) {
            dld = DataBlock.of(ld);
        } else {
            dld = DataBlock.make(ld.length() - st.getUnitRoots().getDegree());
            st.getUnitRoots().apply(ld, (DoubleSeq.Mutable)dld);
        }
        if (model.isMean()) {
            dld.sub(concentratedLikelihood.coefficients().get(0));
        }
        FastKalmanFilter kf = new FastKalmanFilter((IArimaModel)st.getStationaryModel());
        Likelihood ll = kf.process((DoubleSeq)dld);
        return ll.e();
    }

    public static IRegArimaComputer<SarimaModel> processor(boolean ml, double eps) {
        HannanRissanenInitializer initializer = HannanRissanenInitializer.builder().stabilize(true).useDefaultIfFailed(true).build();
        return GlsSarimaComputer.builder().minimizer(LevenbergMarquardtMinimizer.builder()).precision(eps).initializer(initializer).useMaximumLikelihood(ml).build();
    }

    public static RegArimaModel<SarimaModel> airlineModel(DoubleSeq data, boolean mean, int ifreq, boolean seas) {
        SarimaOrders spec = seas ? SarimaOrders.airline((int)ifreq) : SarimaOrders.m011((int)ifreq);
        SarimaModel arima = SarimaModel.builder(spec).setDefault().build();
        return RegArimaModel.builder().arima(arima).y(data).meanCorrection(mean).build();
    }

    public static BackFilter differencingFilter(int freq, int d, int bd) {
        Polynomial X = null;
        if (d > 0) {
            X = UnitRoots.D(1, d);
        }
        if (bd > 0) {
            Polynomial XD = UnitRoots.D(freq, bd);
            X = X == null ? XD : X.times(XD);
        }
        if (X == null) {
            X = Polynomial.ONE;
        }
        return new BackFilter(X);
    }

    public static double[] meanRegressionVariable(BackFilter differencing, int n) {
        double[] m = new double[n];
        RegArimaUtility.meanRegressionVariable(differencing, n, m, 0);
        return m;
    }

    public static void meanRegressionVariable(BackFilter differencing, int n, double[] m, int start) {
        double[] D = differencing.asPolynomial().toArray();
        int d = D.length - 1;
        m[start + d] = 1.0;
        for (int i = d + 1; i < n; ++i) {
            double s = 1.0;
            for (int j = 1; j <= d; ++j) {
                s -= m[i - j] * D[j];
            }
            m[start + i] = s;
        }
    }

    public static int defaultLjungBoxLength(int period) {
        switch (period) {
            case 12: {
                return 24;
            }
            case 1: {
                return 8;
            }
        }
        return 4 * period;
    }

    @Generated
    private RegArimaUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

