/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.pca;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.ISingularValueDecomposition;
import jdplus.toolkit.base.core.math.matrices.decomposition.SingularValueDecomposition;

public class PrincipalComponents {
    private FastMatrix data;
    private ISingularValueDecomposition svd;
    private double scaling;

    public boolean process(FastMatrix data) {
        FastMatrix ndata;
        this.clear();
        this.data = data;
        this.svd = new SingularValueDecomposition();
        if (data.getColumnsCount() == 1) {
            ndata = data;
            this.scaling = 1.0;
        } else {
            this.scaling = 1.0 / Math.sqrt(data.getColumnsCount() - 1);
            ndata = data.times(this.scaling);
        }
        this.svd.decompose(ndata);
        return this.svd.isFullRank();
    }

    private void clear() {
        this.svd = null;
        this.data = null;
        this.scaling = 1.0;
    }

    public double getScaling() {
        return this.scaling;
    }

    public FastMatrix getData() {
        return this.data;
    }

    public ISingularValueDecomposition getSvd() {
        return this.svd;
    }

    public DoubleSeq getSingularValues() {
        return this.svd.S();
    }

    public FastMatrix getEigenVectors() {
        return this.svd.V();
    }

    public DataBlock getEigenVector(int pos) {
        return this.svd.V().column(pos);
    }

    public DataBlock getFactor(int pos) {
        DataBlock u = this.svd.U().column(pos).deepClone();
        u.mul(this.svd.S().get(pos));
        return u;
    }
}

