/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.tramoseats.base.core.tramo.ModelComparator;
import jdplus.tramoseats.base.core.tramo.ModelController;
import jdplus.tramoseats.base.core.tramo.TramoContext;

class SeasonalUnderDifferencingTest2
extends ModelController {
    private static final double DEF_SBOUND = 0.91;

    SeasonalUnderDifferencingTest2() {
    }

    @Override
    ProcessingResult process(RegSarimaModelling modelling, TramoContext context) {
        boolean hastdmh;
        ModelDescription desc = modelling.getDescription();
        int period = desc.getAnnualFrequency();
        if (period == 1) {
            return ProcessingResult.Unprocessed;
        }
        SarimaOrders spec = desc.specification();
        if (spec.getBd() == 1 || spec.getBq() == 1 || context.originalSeasonalityTest == 0) {
            return ProcessingResult.Unchanged;
        }
        if (spec.getBp() == 1 && !(hastdmh = desc.variables().filter(var -> ModellingUtility.isCalendar((Variable)var)).findAny().isPresent())) {
            return ProcessingResult.Unchanged;
        }
        RegSarimaModelling scontext = this.buildNewModel(modelling);
        ModelComparator cmp = ModelComparator.builder().build();
        if (cmp.compare(scontext, modelling) < 0) {
            this.setReferenceModel(scontext);
            this.transferInformation(scontext, modelling);
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }

    private RegSarimaModelling buildNewModel(RegSarimaModelling context) {
        ModelDescription ndesc = ModelDescription.copyOf((ModelDescription)context.getDescription());
        SarimaOrders spec = ndesc.specification();
        spec.setBp(0);
        spec.setBd(1);
        spec.setBq(1);
        ndesc.setSpecification(spec);
        ndesc.setMean(false);
        RegSarimaModelling ncontext = RegSarimaModelling.of((ModelDescription)ndesc);
        if (!this.estimate(ncontext, false)) {
            return null;
        }
        return ncontext;
    }
}

