/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.time.LocalDateTime;
import java.util.Arrays;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class TrigonometricVariables
implements ITsVariable {
    private final double[] frequencies;
    private final LocalDateTime reference;

    public static TrigonometricVariables regular(int periodicity) {
        return TrigonometricVariables.regular(periodicity, TsPeriod.DEFAULT_EPOCH);
    }

    public static TrigonometricVariables regular(int periodicity, LocalDateTime ref) {
        int n = periodicity / 2;
        double[] freq = new double[n];
        double f = 2.0 / (double)periodicity;
        for (int i = 1; i <= n; ++i) {
            freq[i - 1] = f * (double)i;
        }
        return new TrigonometricVariables(freq, ref);
    }

    public static TrigonometricVariables regular(int periodicity, int[] seasfreq) {
        return TrigonometricVariables.regular(periodicity, seasfreq, TsPeriod.DEFAULT_EPOCH);
    }

    public static TrigonometricVariables regular(int periodicity, int[] seasfreq, LocalDateTime ref) {
        double[] freq = new double[seasfreq.length];
        double f = 2.0 / (double)periodicity;
        for (int i = 0; i < seasfreq.length; ++i) {
            freq[i] = f * (double)seasfreq[i];
        }
        return new TrigonometricVariables(freq, ref);
    }

    public static TrigonometricVariables all(double periodicity, int nfreq) {
        double[] freq = new double[nfreq];
        double f = 2.0 / periodicity;
        for (int i = 1; i <= nfreq; ++i) {
            freq[i - 1] = f * (double)i;
        }
        return new TrigonometricVariables(freq, TsPeriod.DEFAULT_EPOCH);
    }

    @Override
    public int dim() {
        int n = this.frequencies.length;
        return this.frequencies[n - 1] == 1.0 ? 2 * n - 1 : 2 * n;
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        return "trigonometric variable";
    }

    @Generated
    public TrigonometricVariables(double[] frequencies, LocalDateTime reference) {
        this.frequencies = frequencies;
        this.reference = reference;
    }

    @Generated
    public double[] getFrequencies() {
        return this.frequencies;
    }

    @Generated
    public LocalDateTime getReference() {
        return this.reference;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrigonometricVariables)) {
            return false;
        }
        TrigonometricVariables other = (TrigonometricVariables)o;
        if (!Arrays.equals(this.getFrequencies(), other.getFrequencies())) {
            return false;
        }
        LocalDateTime this$reference = this.getReference();
        LocalDateTime other$reference = other.getReference();
        return !(this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getFrequencies());
        LocalDateTime $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : ((Object)$reference).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "TrigonometricVariables(frequencies=" + Arrays.toString(this.getFrequencies()) + ", reference=" + String.valueOf(this.getReference()) + ")";
    }
}

