/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.processing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.util.WildCards;
import lombok.Generated;
import lombok.NonNull;

public class GenericOutput
implements Explorable {
    @NonNull
    private Map<String, Object> entries;

    public static GenericOutput of(Explorable explorable, List<String> items) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String item : items) {
            if (WildCards.hasWildCards(item)) {
                Map<String, Object> all = explorable.searchAll(item, Object.class);
                for (String s : all.keySet()) {
                    Object obj = explorable.getData(s);
                    if (obj == null) continue;
                    map.put(s, obj);
                }
                continue;
            }
            Object obj = explorable.getData(item);
            if (obj == null) continue;
            map.put(item, obj);
        }
        return new GenericOutput(Collections.unmodifiableMap(map));
    }

    @Override
    public boolean contains(String id) {
        return this.entries.containsKey(id);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        this.entries.forEach((key, obj) -> dic.put((String)key, obj.getClass()));
        return dic;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        Object obj = this.entries.get(id);
        if (tclass.isInstance(obj)) {
            return (T)obj;
        }
        return null;
    }

    @Override
    public <T> Map<String, T> searchAll(String pattern, Class<T> tclass) {
        LinkedHashMap rslt = new LinkedHashMap();
        WildCards wc = new WildCards(pattern);
        this.entries.forEach((key, obj) -> {
            if (wc.match((String)key) && tclass.isInstance(obj)) {
                rslt.put(key, obj);
            }
        });
        return rslt;
    }

    @Generated
    GenericOutput(@NonNull Map<String, Object> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        this.entries = entries;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public Map<String, Object> getEntries() {
        return this.entries;
    }

    @Generated
    public static class Builder {
        @Generated
        private ArrayList<String> entries$key;
        @Generated
        private ArrayList<Object> entries$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder entry(String entryKey, Object entryValue) {
            if (this.entries$key == null) {
                this.entries$key = new ArrayList();
                this.entries$value = new ArrayList();
            }
            this.entries$key.add(entryKey);
            this.entries$value.add(entryValue);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder entries(@org.jspecify.annotations.NonNull Map<? extends String, ? extends Object> entries) {
            if (entries == null) {
                throw new NullPointerException("entries cannot be null");
            }
            if (this.entries$key == null) {
                this.entries$key = new ArrayList();
                this.entries$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : entries.entrySet()) {
                this.entries$key.add($lombokEntry.getKey());
                this.entries$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearEntries() {
            if (this.entries$key != null) {
                this.entries$key.clear();
                this.entries$value.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull GenericOutput build() {
            Map<String, Object> entries;
            switch (this.entries$key == null ? 0 : this.entries$key.size()) {
                case 0: {
                    entries = Collections.emptyMap();
                    break;
                }
                case 1: {
                    entries = Collections.singletonMap(this.entries$key.get(0), this.entries$value.get(0));
                    break;
                }
                default: {
                    entries = new LinkedHashMap<String, Object>(this.entries$key.size() < 0x40000000 ? 1 + this.entries$key.size() + (this.entries$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.entries$key.size(); ++$i) {
                        entries.put(this.entries$key.get($i), this.entries$value.get($i));
                    }
                    entries = Collections.unmodifiableMap(entries);
                }
            }
            return new GenericOutput(entries);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "GenericOutput.Builder(entries$key=" + String.valueOf(this.entries$key) + ", entries$value=" + String.valueOf(this.entries$value) + ")";
        }
    }
}

