/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import java.util.Collections;
import java.util.function.Function;
import jdplus.toolkit.base.api.util.TreeTraverser;
import lombok.Generated;
import lombok.NonNull;

public final class MultiLineNameUtil {
    private static final char RIGHT_POINTING_TRIANGLE = '\u25b6';
    private static final char HORIZONTAL_ELLIPSIS = '\u2026';
    private static final String JOIN_SEP = " \u25b6 ";
    private static final String LAST_PREFIX = "\u2026 ";
    public static final String SEPARATOR = "\n";

    @NonNull
    public static String join(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return MultiLineNameUtil.join(input, JOIN_SEP);
    }

    @NonNull
    public static String join(@NonNull String input, @NonNull String separator) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        return input.replace(SEPARATOR, separator);
    }

    @NonNull
    public static String toHtml(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String[] items = input.split(SEPARATOR, -1);
        Function<Integer, Iterable> children = o -> o < items.length - 1 ? Collections.singletonList(o + 1) : Collections.emptyList();
        Function<Integer, String> toString = o -> (o == 0 ? "" : " ") + items[o] + "<br>";
        String result = TreeTraverser.of(0, children).prettyPrintToString(Integer.MAX_VALUE, toString);
        return "<html>" + result.replace(" ", "&nbsp;");
    }

    @NonNull
    public static String last(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        int index = input.lastIndexOf(SEPARATOR);
        return index == -1 ? input : input.substring(index + 1);
    }

    @NonNull
    public static String lastWithMax(@NonNull String input, int maxLength) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String last = MultiLineNameUtil.last(input);
        return last.length() < maxLength ? last : LAST_PREFIX + last.substring(last.length() - maxLength);
    }

    @Generated
    private MultiLineNameUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

