/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.dstats.Normal;

@FunctionalInterface
public interface RobustStandardDeviationComputer {
    public double compute(DoubleSeq var1);

    public static RobustStandardDeviationComputer mad() {
        return Mad2.DEFAULT;
    }

    public static RobustStandardDeviationComputer mad(boolean mediancorrected) {
        return mediancorrected ? Mad2.DEFAULT : Mad.DEFAULT;
    }

    public static RobustStandardDeviationComputer mad(double centile, boolean mediancorrected) {
        return mediancorrected ? new Mad2(centile) : new Mad(centile);
    }

    public static final class Mad2
    implements RobustStandardDeviationComputer {
        public static final Mad2 DEFAULT = new Mad2(50.0);
        private final double centile;

        Mad2(double centile) {
            this.centile = centile;
        }

        @Override
        public double compute(DoubleSeq data) {
            double[] e = data.toArray();
            int n = e.length;
            Arrays.sort(e);
            int n2 = n / 2;
            double median = n2 * 2 == n ? (e[n2 - 1] + e[n2]) / 2.0 : e[n2];
            for (int i = 0; i < n; ++i) {
                if (e[i] >= median) {
                    int n3 = i;
                    e[n3] = e[n3] - median;
                    continue;
                }
                e[i] = median - e[i];
            }
            Arrays.sort(e);
            double dnm = (double)(n + 1) * this.centile / 100.0;
            int nm = (int)dnm;
            double dx = dnm - (double)nm;
            double m = dx < 1.0E-9 ? e[nm - 1] : e[nm - 1] * (1.0 - dx) + e[nm] * dx;
            Normal normal = new Normal();
            double l = normal.getProbabilityInverse(0.5 + 0.005 * this.centile, ProbabilityType.Lower);
            return m / l;
        }
    }

    public static final class Mad
    implements RobustStandardDeviationComputer {
        public static final Mad DEFAULT = new Mad(50.0);
        private final double centile;

        Mad(double centile) {
            this.centile = centile;
        }

        @Override
        public double compute(DoubleSeq e) {
            double[] a = e.toArray();
            int n = a.length;
            for (int i = 0; i < n; ++i) {
                a[i] = Math.abs(a[i]);
            }
            Arrays.sort(a);
            double dnm = (double)(n + 1) * this.centile / 100.0;
            int nm = (int)dnm;
            double dx = dnm - (double)nm;
            double m = dx < 1.0E-9 ? a[nm - 1] : a[nm - 1] * (1.0 - dx) + a[nm] * dx;
            Normal normal = new Normal();
            double l = normal.getProbabilityInverse(0.5 + 0.005 * this.centile, ProbabilityType.Lower);
            return m / l;
        }
    }
}

