/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.dstats.Normal;

public class InverseGaussian
implements ContinuousDistribution {
    private final double mu;
    private final double lambda;

    public InverseGaussian(double mu, double lambda) {
        this.mu = mu;
        this.lambda = lambda;
    }

    public double getDensity(double x) throws DStatException {
        if (x == 0.0) {
            return 0.0;
        }
        return Math.sqrt(this.lambda / (Math.PI * 2 * x * x * x)) * Math.exp(-this.lambda * (x - this.mu) * (x - this.mu) / (2.0 * this.mu * this.mu * x));
    }

    public double getLeftBound() {
        return 0.0;
    }

    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Inverse Gaussian with mean = ");
        sb.append(this.mu);
        sb.append(" and shape = ");
        sb.append(this.lambda);
        return sb.toString();
    }

    public double getExpectation() throws DStatException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double getProbability(double x, ProbabilityType pt) throws DStatException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double getProbabilityInverse(double p, ProbabilityType pt) throws DStatException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double getVariance() throws DStatException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BoundaryType hasLeftBound() {
        return BoundaryType.Finite;
    }

    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    public boolean isSymmetrical() {
        return false;
    }

    public double random(RandomNumberGenerator rng) throws DStatException {
        return InverseGaussian.random(rng, this.mu, this.lambda);
    }

    public static double random(RandomNumberGenerator rng, double mu, double lambda) {
        double nu = Normal.random(rng, 0.0, 1.0);
        double y = nu * nu;
        double x = mu + mu * mu * y / (2.0 * lambda) - mu / (2.0 * lambda) * Math.sqrt(4.0 * mu * lambda * y + mu * mu * y * y);
        double z = rng.nextDouble();
        if (z > mu / (mu + x)) {
            x = mu * mu / x;
        }
        return x;
    }
}

