/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.NonNull;

@FunctionalInterface
public interface IOPredicate<T> {
    public boolean testWithIO(T var1) throws IOException;

    @NonNull
    default public IOPredicate<T> and(@NonNull IOPredicate<? super T> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return t -> this.testWithIO(t) && other.testWithIO(t);
    }

    @NonNull
    default public IOPredicate<T> negate() {
        return t -> !this.testWithIO(t);
    }

    @NonNull
    default public IOPredicate<T> or(@NonNull IOPredicate<? super T> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return t -> this.testWithIO(t) || other.testWithIO(t);
    }

    @NonNull
    default public Predicate<T> asUnchecked() {
        return t -> {
            try {
                return this.testWithIO(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @NonNull
    public static <T> Predicate<T> unchecked(@NonNull IOPredicate<T> o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return o.asUnchecked();
    }

    @NonNull
    public static <T> IOPredicate<T> checked(@NonNull Predicate<T> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        return o -> {
            try {
                return predicate.test(o);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        };
    }

    @NonNull
    public static <T> IOPredicate<T> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : targetRef::equals;
    }

    @NonNull
    public static <T> IOPredicate<T> of(boolean r) {
        return o -> r;
    }
}

