## ----eval=FALSE---------------------------------------------------------------
# # find all SAGA GIS installations at the default search location
# require(link2GI)
# saga <- link2GI::findSAGA()
# saga

## ----eval=FALSE---------------------------------------------------------------
# require(link2GI)
# if (Sys.info()["sysname"] == "Windows") {
# grass <- link2GI::findGRASS(searchLocation = "C:/")
# otb <- link2GI::findOTB(searchLocation = "C:/")
# } else {
# grass <- link2GI::findGRASS(searchLocation = "/usr/bin",quiet = FALSE)
# otb <- link2GI::findOTB(searchLocation = "~/apps/otb911/",quiet = FALSE)
# }
# grass
# otb

## ----eval=FALSE---------------------------------------------------------------
# require(link2GI)
# dirs <- link2GI::initProj(
#   root_folder    = tempdir(),
#   standard_setup = "baseSpatial"
# )
# 
# dirs <- link2GI::setupProj(
#   root_folder = getwd(),
#   folders     = c("data/level0", "data/level1", "output", "run"),
#   code_subfolder = c("src", "src/functions")
# )
# 
# dirs

## ----eval=FALSE---------------------------------------------------------------
# require(link2GI)
# # find all SAGA GIS installations and take the first one
# saga1 <- link2GI::linkSAGA()
# saga1
# 

## ----eval=FALSE---------------------------------------------------------------
# # get meuse data as sp object and link it temporary to GRASS
# require(link2GI)
# require(sf)
# require(sp)
# crs = 28992
# # get data
# data(meuse)
# meuse_sf = st_as_sf(meuse, coords = c("x", "y"), crs = crs, agr = "constant")
# 
# # Automatic search and find of GRASS binaries
# # using the meuse sp data object for spatial referencing
# # This is the highly recommended linking procedure for on the fly jobs
# # NOTE: if more than one GRASS installation is found the highest version will be selected
# 
# link2GI::linkGRASS(meuse_sf,epsg = crs,quiet = FALSE)

## ----eval=FALSE---------------------------------------------------------------
#  require(link2GI)
#  require(sf)
# 
#  # get  data
#  nc <- st_read(system.file("shape/nc.shp", package="sf"))
# terra::crs(nc)
#  # Automatic search and find of GRASS binaries
#  # using the nc sf data object for spatial referencing
#  # This is the highly recommended linking procedure for on the fly jobs
#  # NOTE: if more than one GRASS installation is found the highest version will be selected
# 
#  grass<-linkGRASS(nc,returnPaths = TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  require(link2GI)
#  require(sf)
# 
#  # proj folders
#  root_folder<-tempdir()
#  paths<-link2GI::createFolders(root_folder = root_folder,
#                           folders = c("project1/"))
# 
#  # get  data
#  nc <- st_read(system.file("shape/nc.shp", package="sf"))
# 
#  # CREATE and link to a permanent GRASS folder at "root_folder", location named "project1"
#  linkGRASS(nc, gisdbase = root_folder, location = "project1", quiet = FALSE)
# 
#  # ONLY LINK to a permanent GRASS folder at "root_folder", location named "project1"
#  linkGRASS(gisdbase = root_folder, location = "project1", gisdbase_exist = TRUE, quiet = FALSE )
# 
# 
#  # setting up GRASS manually with spatial parameters of the nc data
#  epsg = 28992
#  proj4_string <- sp::CRS(paste0("+init=epsg:",epsg))
# 
#  linkGRASS(spatial_params = c(178605,329714,181390,333611,proj4_string@projargs),epsg=epsg,quiet = FALSE)
# 
#  # creating a GRASS gisdbase manually with spatial parameters of the nc data
#  # additionally using a peramanent directory "root_folder" and the location "nc_spatial_params "
#  epsg = 4267
#  proj4_string <- sp::CRS(paste0("+init=epsg:",epsg))@projargs
#  linkGRASS(gisdbase = root_folder,
#             location = "nc_spatial_params",
#             spatial_params = c(-84.32385, 33.88199,-75.45698,36.58965,proj4_string),epsg = epsg)
# 

## ----eval=FALSE---------------------------------------------------------------
# # Link the GRASS installation and define the search location
#  linkGRASS(nc, search_path = "~/apps/otb911")

## ----eval=FALSE---------------------------------------------------------------
# findGRASS()

## ----eval=FALSE---------------------------------------------------------------
# linkGRASS(nc,c("/usr/lib/grass83","8.3.2","grass"),epsg = 4267, quiet = FALSE)

## ----eval=FALSE---------------------------------------------------------------
# # Link the GRASS installation and define the search location
#  linkGRASS(nc, search_path = "C:", quiet = FALSE)

## ----eval=FALSE---------------------------------------------------------------
# findGRASS()

## ----eval=FALSE---------------------------------------------------------------
# linkGRASS(nc,c("C:/OSGeo4W","8.4.1","osgeo4w"),epsg = 4267, quiet = FALSE)

## ----eval=FALSE---------------------------------------------------------------
# linkGRASS(nc, ver_select = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# linkGRASS(x = nc,
#                      gisdbase = "~/temp3",
#                      location = "project1")

## ----eval=FALSE---------------------------------------------------------------
# linkGRASS(gisdbase = "~/temp3", location = "project1",
#                      gisdbase_exist = TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  linkGRASS(spatial_params = c(178605,329714,181390,333611,
#                               "+proj=sterea +lat_0=52.15616055555555
#                                +lon_0=5.38763888888889 +k=0.9999079
#                                +x_0=155000 +y_0=463000 +no_defs
#                                +a=6377397.155 +rf=299.1528128
#                                +towgs84=565.4171,50.3319,465.5524,
#                                 -0.398957,0.343988,-1.8774,4.0725
#                                +to_meter=1"),epsg = 28992)

## ----eval=FALSE---------------------------------------------------------------
# # link to the installed OTB Linux HOME directory
# otblink<-link2GI::linkOTB(searchLocation = "~/apps/")
# 
# # get the list of modules from the linked version
# algo<-parseOTBAlgorithms(gili = otblink)
# 
# algo <- link2GI::otb_capabilities(gili = otblink)
# 

## ----eval=FALSE---------------------------------------------------------------
# ## for the example we use the edge detection,
# ## ------------------------------------------------------------
# ## 1) Select an OTB algorithm by name pattern
# ## ------------------------------------------------------------
# ## grep() returns *all* matching algorithm names as a character vector.
# ## This is intentional for exploration, but NOT valid for execution.
# algoKeyword <- grep("edge", algo, value = TRUE, ignore.case = TRUE)
# 
# ## Inspect matches (important!)
# algoKeyword
# length(algoKeyword)
# 
# ## ------------------------------------------------------------
# ## 2) Select exactly ONE algorithm (mandatory)
# ## ------------------------------------------------------------
# ## Explicitly pick one algorithm from the matches.
# ## This avoids ambiguity and guarantees a scalar character value.
# algo <- algoKeyword[[1]]
# 
# ## ------------------------------------------------------------
# ## 3) Read OTB help text (capabilities)
# ## ------------------------------------------------------------
# ## This parses the OTB -help output and returns the raw help text.
# ## This is the *authoritative source* for parameters.
# caps <- link2GI::otb_capabilities(algo = algo, gili = otblink)
# 
# ## Print the help text to understand available parameters
# cat(paste(caps$text, collapse = "\n"))
# 
# ## ------------------------------------------------------------
# ## 4) Parse parameters into a structured table
# ## ------------------------------------------------------------
# ## otb_args_spec() converts the help text into a data.frame
# ## with keys, types, defaults, and mandatory flags.
# spec <- link2GI::otb_args_spec(algo = algo, gili = otblink)
# 
# ## Inspect the relevant parameter metadata
# spec[, c("key", "mandatory", "default", "class")]
# 
# 
# ## ------------------------------------------------------------
# ## 5) Build a command template with valid parameters only
# ## ------------------------------------------------------------
# ## otb_build_cmd() creates a named list with:
# ## - required parameters
# ## - optional parameters with defaults (if requested)
# ## - no execution yet
# cmd <- link2GI::otb_build_cmd(
#   algo,
#   gili             = otblink,
#   include_optional = "defaults",
#   require_output   = TRUE
# )
# 
# ## Inspect the command structure
# str(cmd)
# 
# ## ------------------------------------------------------------
# ## 6) Show the exact CLI command that WOULD be executed
# ## ------------------------------------------------------------
# ## retCommand = TRUE prints the full otbApplicationLauncherCommandLine call
# ## without running it. This is crucial for transparency and debugging.
# cat(link2GI::runOTB(cmd, otblink, retCommand = TRUE), "\n")
# 
# 
# 

## ----eval=FALSE---------------------------------------------------------------
# require(link2GI)
# require(terra)
# require(listviewer)
# 
# # 0) Link OTB
# otblink <- link2GI::linkOTB(searchLocation = "~/apps/")
# 
# root_folder <- tempdir()
# fn <- system.file("ex/elev.tif", package = "terra")
# 
# # 1) Choose the application (must be a single character scalar)
# algoKeyword <- "EdgeExtraction"
# 
# # 2) Create a command template with valid keys (defaults included)
# cmd <- link2GI::otb_build_cmd(
#   algo            = algoKeyword,
#   gili            = otblink,
#   include_optional = "defaults",
#   require_output   = TRUE
# )
# 
# # 3) Set mandatory arguments (same values as legacy example)
# cmd[["in"]]      <- fn
# cmd[["filter"]]  <- "touzi"
# cmd[["channel"]] <- "1"
# 
# # 4) Set explicit on-disk output (recommended API: otb_set_out)
# out_file <- file.path(root_folder, paste0("out", cmd[["filter"]], ".tif"))
# cmd <- link2GI::otb_set_out(cmd, gili = otblink, key = "out", path = out_file)
# 
# # 5) Run the algorithm and read output as a raster
# retStack <- link2GI::runOTB(cmd, gili = otblink, retRaster = TRUE)
# 
# # 8) Plot result
# plot(retStack)
# 
# 

