/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifdef H5_HAVE_C11_THREADS

#define H5TS_mutex_lock(mutex)   (H5_UNLIKELY(mtx_lock(mutex) != thrd_success) ? FAIL : SUCCEED)
#define H5TS_mutex_unlock(mutex) (H5_UNLIKELY(mtx_unlock(mutex) != thrd_success) ? FAIL : SUCCEED)

#else
#ifdef H5_HAVE_WIN_THREADS

static inline herr_t
H5TS_mutex_lock(H5TS_mutex_t *mutex)
{
    EnterCriticalSection(mutex);

    return SUCCEED;
} 

static inline herr_t
H5TS_mutex_unlock(H5TS_mutex_t *mutex)
{
    LeaveCriticalSection(mutex);

    return SUCCEED;
} 
#else

#define H5TS_mutex_lock(mutex)   (H5_UNLIKELY(0 != pthread_mutex_lock(mutex)) ? FAIL : SUCCEED)
#define H5TS_mutex_unlock(mutex) (H5_UNLIKELY(0 != pthread_mutex_unlock(mutex)) ? FAIL : SUCCEED)

#endif
#endif
