/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramo;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.tramoseats.base.api.tramo.Tramo;

public final class TramoLoader {

    public static final class Processor {
        private final Iterable<Tramo.Processor> source = ServiceLoader.load(Tramo.Processor.class);
        private final AtomicReference<Tramo.Processor> resource = new AtomicReference<Tramo.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private Tramo.Processor doLoad() {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseGet(() -> new Tramo.DefProcessor());
        }

        public Tramo.Processor get() {
            return this.resource.get();
        }

        public void set(Tramo.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() {
            Iterable<Tramo.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Iterable<Tramo.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

