/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.ComplexType;

public final class ComplexComputer
implements ComplexType {
    private double re;
    private double im;

    public ComplexComputer(ComplexType c) {
        this.re = c.getRe();
        this.im = c.getIm();
    }

    public ComplexComputer(double re) {
        this.re = re;
        this.im = 0.0;
    }

    public ComplexComputer(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public double getRe() {
        return this.re;
    }

    public double getIm() {
        return this.im;
    }

    public ComplexComputer add(ComplexType c) {
        this.re += c.getRe();
        this.im += c.getIm();
        return this;
    }

    public ComplexComputer addAC(double a, ComplexType c) {
        this.re += a * c.getRe();
        this.im += a * c.getIm();
        return this;
    }

    public ComplexComputer add(double a) {
        this.re += a;
        return this;
    }

    public ComplexComputer chs() {
        this.re = -this.re;
        this.im = -this.im;
        return this;
    }

    public ComplexComputer div(ComplexType c) {
        return this.div(c.getRe(), c.getIm());
    }

    public ComplexComputer div(double r) {
        this.re /= r;
        this.im /= r;
        return this;
    }

    public ComplexComputer div(double x, double y) {
        double dIm;
        double dRe;
        if (Math.abs(x) >= Math.abs(y)) {
            double scalar = 1.0 / (x + y * (y / x));
            dRe = scalar * (this.re + this.im * (y / x));
            dIm = scalar * (this.im - this.re * (y / x));
        } else {
            double scalar = 1.0 / (x * (x / y) + y);
            dRe = scalar * (this.re * (x / y) + this.im);
            dIm = scalar * (this.im * (x / y) - this.re);
        }
        this.re = dRe;
        this.im = dIm;
        return this;
    }

    public ComplexComputer inv() {
        double zIm;
        double zRe;
        if (Math.abs(this.re) >= Math.abs(this.im)) {
            double scalar;
            zRe = scalar = 1.0 / (this.re + this.im * (this.im / this.re));
            zIm = scalar * (-this.im / this.re);
        } else {
            double scalar = 1.0 / (this.re * (this.re / this.im) + this.im);
            zRe = scalar * (this.re / this.im);
            zIm = -scalar;
        }
        this.re = zRe;
        this.im = zIm;
        return this;
    }

    public ComplexComputer mul(ComplexType c) {
        return this.mul(c.getRe(), c.getIm());
    }

    public ComplexComputer mul(double r) {
        if (r == 0.0) {
            this.re = 0.0;
            this.im = 0.0;
        } else {
            this.re *= r;
            this.im *= r;
        }
        return this;
    }

    public ComplexComputer mul(double x, double y) {
        double tmp = this.re * x - this.im * y;
        this.im = this.re * y + this.im * x;
        this.re = tmp;
        return this;
    }

    public ComplexComputer sub(ComplexType c) {
        this.re -= c.getRe();
        this.im -= c.getIm();
        return this;
    }

    public ComplexComputer sub(double r) {
        this.re -= r;
        return this;
    }

    public Complex result() {
        return Complex.cart((double)this.re, (double)this.im);
    }
}

