/*
 * Decompiled with CFR 0.152.
 */
package internal.text.base.api;

import jdplus.toolkit.base.api.design.DemetraPlusLegacy;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.Parser;
import org.jspecify.annotations.Nullable;

@DemetraPlusLegacy
public final class TxtLegacyId {
    private static final String SEP = "@";
    @NonNull
    private final String file;
    private final int seriesIndex;

    @NonNull
    public static TxtLegacyId collection(@NonNull String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        return new TxtLegacyId(fileName, -1);
    }

    @NonNull
    public static TxtLegacyId series(@NonNull String fileName, int indexSeries) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        return new TxtLegacyId(fileName, indexSeries);
    }

    public static @Nullable TxtLegacyId parse(@NonNull String monikerId) {
        if (monikerId == null) {
            throw new NullPointerException("monikerId is marked non-null but is null");
        }
        String[] parts = monikerId.split(SEP, -1);
        try {
            switch (parts.length) {
                case 2: {
                    return Parser.onInteger().parseValue((CharSequence)parts[1]).map(index -> TxtLegacyId.series(parts[0], index)).orElse(null);
                }
                case 1: {
                    return TxtLegacyId.collection(parts[0]);
                }
            }
            return null;
        }
        catch (NumberFormatException err) {
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.file);
        if (this.isSeries()) {
            builder.append(SEP).append(this.seriesIndex);
        }
        return builder.toString();
    }

    public boolean isSeries() {
        return this.seriesIndex >= 0;
    }

    @Generated
    public TxtLegacyId(@NonNull String file, int seriesIndex) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.file = file;
        this.seriesIndex = seriesIndex;
    }

    @NonNull
    @Generated
    public String getFile() {
        return this.file;
    }

    @Generated
    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxtLegacyId)) {
            return false;
        }
        TxtLegacyId other = (TxtLegacyId)o;
        if (this.getSeriesIndex() != other.getSeriesIndex()) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        return !(this$file == null ? other$file != null : !this$file.equals(other$file));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSeriesIndex();
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        return result;
    }
}

