/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.jsoup.nodes;

import org.jspecify.annotations.Nullable;
import standalone_spreadsheet.org.jsoup.internal.QuietAppendable;
import standalone_spreadsheet.org.jsoup.internal.StringUtil;
import standalone_spreadsheet.org.jsoup.nodes.Document;
import standalone_spreadsheet.org.jsoup.nodes.Element;
import standalone_spreadsheet.org.jsoup.nodes.Entities;
import standalone_spreadsheet.org.jsoup.nodes.LeafNode;
import standalone_spreadsheet.org.jsoup.nodes.Node;
import standalone_spreadsheet.org.jsoup.nodes.NodeUtils;
import standalone_spreadsheet.org.jsoup.nodes.TextNode;
import standalone_spreadsheet.org.jsoup.parser.Tag;
import standalone_spreadsheet.org.jsoup.select.NodeVisitor;

class Printer
implements NodeVisitor {
    final Node root;
    final QuietAppendable accum;
    final Document.OutputSettings settings;

    Printer(Node root, QuietAppendable accum, Document.OutputSettings settings) {
        this.root = root;
        this.accum = accum;
        this.settings = settings;
    }

    void addHead(Element el, int depth) {
        el.outerHtmlHead(this.accum, this.settings);
    }

    void addTail(Element el, int depth) {
        el.outerHtmlTail(this.accum, this.settings);
    }

    void addText(TextNode textNode, int textOptions, int depth) {
        int options = 1 | textOptions;
        Entities.escape(this.accum, textNode.coreValue(), this.settings, options);
    }

    void addNode(LeafNode node, int depth) {
        node.outerHtmlHead(this.accum, this.settings);
    }

    void indent(int depth) {
        this.accum.append('\n').append(StringUtil.padding(depth * this.settings.indentAmount(), this.settings.maxPaddingWidth()));
    }

    @Override
    public void head(Node node, int depth) {
        if (node.getClass() == TextNode.class) {
            this.addText((TextNode)node, 0, depth);
        } else if (node instanceof Element) {
            this.addHead((Element)node, depth);
        } else {
            this.addNode((LeafNode)node, depth);
        }
    }

    @Override
    public void tail(Node node, int depth) {
        if (node instanceof Element) {
            this.addTail((Element)node, depth);
        }
    }

    static Printer printerFor(Node root, QuietAppendable accum) {
        Document.OutputSettings settings = NodeUtils.outputSettings(root);
        if (settings.outline()) {
            return new Outline(root, accum, settings);
        }
        if (settings.prettyPrint()) {
            return new Pretty(root, accum, settings);
        }
        return new Printer(root, accum, settings);
    }

    static class Outline
    extends Pretty {
        Outline(Node root, QuietAppendable accum, Document.OutputSettings settings) {
            super(root, accum, settings);
        }

        @Override
        boolean isBlockEl(@Nullable Node node) {
            return node != null;
        }

        @Override
        boolean shouldIndent(@Nullable Node node) {
            if (node == null || node == this.root || this.preserveWhitespace || Outline.isBlankText(node)) {
                return false;
            }
            if (node instanceof TextNode) {
                return node.previousSibling() != null || node.nextSibling() != null;
            }
            return true;
        }
    }

    static class Pretty
    extends Printer {
        boolean preserveWhitespace = false;
        private static final int maxScan = 5;

        Pretty(Node root, QuietAppendable accum, Document.OutputSettings settings) {
            super(root, accum, settings);
            for (Node node = root; node != null; node = node.parentNode()) {
                if (!Pretty.tagIs(Tag.PreserveWhitespace, node)) continue;
                this.preserveWhitespace = true;
                break;
            }
        }

        @Override
        void addHead(Element el, int depth) {
            if (this.shouldIndent(el)) {
                this.indent(depth);
            }
            super.addHead(el, depth);
            if (Pretty.tagIs(Tag.PreserveWhitespace, el)) {
                this.preserveWhitespace = true;
            }
        }

        @Override
        void addTail(Element el, int depth) {
            if (this.shouldIndent(Pretty.nextNonBlank(el.firstChild()))) {
                this.indent(depth);
            }
            super.addTail(el, depth);
            if (this.preserveWhitespace && el.tag.is(Tag.PreserveWhitespace)) {
                for (Element parent = el.parent(); parent != null; parent = parent.parent()) {
                    if (!parent.tag().preserveWhitespace()) continue;
                    return;
                }
                this.preserveWhitespace = false;
            }
        }

        @Override
        void addNode(LeafNode node, int depth) {
            if (this.shouldIndent(node)) {
                this.indent(depth);
            }
            super.addNode(node, depth);
        }

        @Override
        void addText(TextNode node, int textOptions, int depth) {
            if (!this.preserveWhitespace) {
                textOptions |= 4;
                textOptions = this.textTrim(node, textOptions);
                if (!node.isBlank() && this.isBlockEl(node.parentNode) && this.shouldIndent(node)) {
                    this.indent(depth);
                }
            }
            super.addText(node, textOptions, depth);
        }

        int textTrim(TextNode node, int options) {
            if (!this.isBlockEl(node.parentNode)) {
                return options;
            }
            Node prev = node.previousSibling();
            Node next = node.nextSibling();
            if ((!(prev instanceof Element) || this.isBlockEl(prev)) && (prev == null || !(prev instanceof TextNode) && this.shouldIndent(prev))) {
                options |= 8;
            }
            if (next == null || !(next instanceof TextNode) && this.shouldIndent(next)) {
                options |= 0x10;
            } else if ((next = Pretty.nextNonBlank(next)) instanceof TextNode && StringUtil.isWhitespace(next.nodeValue().codePointAt(0))) {
                options |= 0x10;
            }
            return options;
        }

        boolean shouldIndent(@Nullable Node node) {
            if (node == null || node == this.root || this.preserveWhitespace || Pretty.isBlankText(node)) {
                return false;
            }
            if (this.isBlockEl(node)) {
                return true;
            }
            Node prevSib = Pretty.previousNonblank(node);
            if (this.isBlockEl(prevSib)) {
                return true;
            }
            Element parent = node.parentNode;
            if (!this.isBlockEl(parent) || parent.tag().is(Tag.InlineContainer) || !Pretty.hasNonTextNodes(parent)) {
                return false;
            }
            return prevSib == null || !(prevSib instanceof TextNode) && (this.isBlockEl(prevSib) || !(prevSib instanceof Element));
        }

        boolean isBlockEl(@Nullable Node node) {
            if (node == null) {
                return false;
            }
            if (node instanceof Element) {
                Element el = (Element)node;
                return el.isBlock() || !el.tag.isKnownTag() && (el.parentNode instanceof Document || Pretty.hasChildBlocks(el));
            }
            return false;
        }

        static boolean hasChildBlocks(Element el) {
            Element child = el.firstElementChild();
            for (int i = 0; i < 5 && child != null; child = child.nextElementSibling(), ++i) {
                if (!child.isBlock() && child.tag.isKnownTag()) continue;
                return true;
            }
            return false;
        }

        static boolean hasNonTextNodes(Element el) {
            Node child = el.firstChild();
            for (int i = 0; i < 5 && child != null; child = child.nextSibling(), ++i) {
                if (child instanceof TextNode) continue;
                return true;
            }
            return false;
        }

        static @Nullable Node previousNonblank(Node node) {
            Node prev = node.previousSibling();
            while (Pretty.isBlankText(prev)) {
                prev = prev.previousSibling();
            }
            return prev;
        }

        static @Nullable Node nextNonBlank(@Nullable Node node) {
            while (Pretty.isBlankText(node)) {
                node = node.nextSibling();
            }
            return node;
        }

        static boolean isBlankText(@Nullable Node node) {
            return node instanceof TextNode && ((TextNode)node).isBlank();
        }

        static boolean tagIs(int option, @Nullable Node node) {
            return node instanceof Element && ((Element)node).tag.is(option);
        }
    }
}

