/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.topology.merge;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import usf.saav.topology.TopoTreeNode;

public abstract class AbstractMergeTreeNode
implements TopoTreeNode {
    protected Vector<AbstractMergeTreeNode> children = new Vector();
    protected AbstractMergeTreeNode parent = null;
    protected AbstractMergeTreeNode partner = null;
    public Object creator = null;
    private static final Random random = new Random();
    String ustr = null;

    protected AbstractMergeTreeNode(Object object) {
        this.creator = object;
    }

    public void addChild(AbstractMergeTreeNode abstractMergeTreeNode) {
        this.children.add(abstractMergeTreeNode);
    }

    public void addChildren(Collection<AbstractMergeTreeNode> collection) {
        this.children.addAll(collection);
    }

    public AbstractMergeTreeNode getChild(int n) {
        return this.children.get(n);
    }

    public List<AbstractMergeTreeNode> getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public boolean isChild(AbstractMergeTreeNode abstractMergeTreeNode) {
        return this.children.contains(abstractMergeTreeNode);
    }

    public int childCount() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public void removeChild(AbstractMergeTreeNode abstractMergeTreeNode) {
        this.children.remove(abstractMergeTreeNode);
    }

    public void setPartner(AbstractMergeTreeNode abstractMergeTreeNode) {
        this.partner = abstractMergeTreeNode;
    }

    @Override
    public AbstractMergeTreeNode getPartner() {
        return this.partner;
    }

    @Override
    public float getBirth() {
        if (this.partner == null) {
            return this.getValue();
        }
        return Math.min(this.getValue(), this.partner.getValue());
    }

    @Override
    public float getDeath() {
        if (this.partner == null) {
            return Float.MAX_VALUE;
        }
        return Math.max(this.getValue(), this.partner.getValue());
    }

    @Override
    public float getPersistence() {
        if (this.partner == null) {
            return Float.MAX_VALUE;
        }
        return Math.abs(this.getValue() - this.partner.getValue());
    }

    public void setParent(AbstractMergeTreeNode abstractMergeTreeNode) {
        this.parent = abstractMergeTreeNode;
    }

    public AbstractMergeTreeNode getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public static char MakeRandomCharacter() {
        int n = random.nextInt(25);
        if (n < 26) {
            return (char)(97 + n);
        }
        if (n < 36) {
            return (char)(48 + n - 26);
        }
        System.out.println(n);
        return 'a';
    }

    public static String MakeRandomString(int n) {
        Object object = "";
        for (int i = 0; i < n; ++i) {
            object = (String)object + AbstractMergeTreeNode.MakeRandomCharacter();
        }
        return object;
    }

    public String getUniqueID() {
        if (this.ustr == null) {
            this.ustr = AbstractMergeTreeNode.MakeRandomString(10);
        }
        return this.ustr;
    }

    @Override
    public TopoTreeNode.NodeType getType() {
        switch (this.childCount()) {
            case 0: {
                return TopoTreeNode.NodeType.LEAF;
            }
            case 1: {
                return TopoTreeNode.NodeType.NONCRITICAL;
            }
        }
        return TopoTreeNode.NodeType.SADDLE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, "| ");
        return stringBuffer.toString();
    }

    private void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + this.getID() + ": " + this.getValue() + "\n");
        if (this.children != null) {
            for (AbstractMergeTreeNode abstractMergeTreeNode : this.children) {
                abstractMergeTreeNode.toString(stringBuffer, "  " + string);
            }
        }
    }

    public void toDot(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        LinkedList<AbstractMergeTreeNode> linkedList = new LinkedList<AbstractMergeTreeNode>();
        linkedList.add(this);
        while (!linkedList.isEmpty()) {
            AbstractMergeTreeNode abstractMergeTreeNode = (AbstractMergeTreeNode)linkedList.poll();
            stringBuffer.append("\t" + abstractMergeTreeNode.getUniqueID() + "[label=\"" + abstractMergeTreeNode.getID() + " (" + abstractMergeTreeNode.getValue() + ")\"];\n");
            AbstractMergeTreeNode abstractMergeTreeNode2 = abstractMergeTreeNode.getPartner();
            if (abstractMergeTreeNode2 != null) {
                stringBuffer2.append("\t" + abstractMergeTreeNode.getUniqueID() + " -> " + abstractMergeTreeNode2.getUniqueID() + " [color=\"red\"]\n");
            }
            for (AbstractMergeTreeNode abstractMergeTreeNode3 : abstractMergeTreeNode.getChildren()) {
                stringBuffer2.append("\t" + abstractMergeTreeNode.getUniqueID() + " -> " + abstractMergeTreeNode3.getUniqueID() + "\n");
            }
            linkedList.addAll(abstractMergeTreeNode.getChildren());
        }
    }

    public static List<AbstractMergeTreeNode> findLeaves(AbstractMergeTreeNode abstractMergeTreeNode) {
        Vector<AbstractMergeTreeNode> vector = new Vector<AbstractMergeTreeNode>();
        ArrayDeque<AbstractMergeTreeNode> arrayDeque = new ArrayDeque<AbstractMergeTreeNode>();
        arrayDeque.push(abstractMergeTreeNode);
        while (!arrayDeque.isEmpty()) {
            AbstractMergeTreeNode abstractMergeTreeNode2 = (AbstractMergeTreeNode)arrayDeque.pop();
            if (!abstractMergeTreeNode2.hasChildren()) {
                vector.add(abstractMergeTreeNode2);
            }
            for (AbstractMergeTreeNode abstractMergeTreeNode3 : abstractMergeTreeNode2.children) {
                arrayDeque.push(abstractMergeTreeNode3);
            }
        }
        return vector;
    }

    public static void findParents(AbstractMergeTreeNode abstractMergeTreeNode) {
        ArrayDeque<AbstractMergeTreeNode> arrayDeque = new ArrayDeque<AbstractMergeTreeNode>();
        arrayDeque.push(abstractMergeTreeNode);
        while (!arrayDeque.isEmpty()) {
            AbstractMergeTreeNode abstractMergeTreeNode2 = (AbstractMergeTreeNode)arrayDeque.pop();
            for (AbstractMergeTreeNode abstractMergeTreeNode3 : abstractMergeTreeNode2.children) {
                abstractMergeTreeNode3.setParent(abstractMergeTreeNode2);
                arrayDeque.push(abstractMergeTreeNode3);
            }
        }
    }

    public static class ComparatorPersistence
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof AbstractMergeTreeNode && object2 instanceof AbstractMergeTreeNode) {
                if (((AbstractMergeTreeNode)object).getPersistence() > ((AbstractMergeTreeNode)object2).getPersistence()) {
                    return 1;
                }
                if (((AbstractMergeTreeNode)object).getPersistence() < ((AbstractMergeTreeNode)object2).getPersistence()) {
                    return -1;
                }
                if (((AbstractMergeTreeNode)object).getID() < ((AbstractMergeTreeNode)object2).getID()) {
                    return 1;
                }
                if (((AbstractMergeTreeNode)object).getID() > ((AbstractMergeTreeNode)object2).getID()) {
                    return -1;
                }
            }
            return 0;
        }
    }

    public static class ComparatorValueDescending
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof AbstractMergeTreeNode && object2 instanceof AbstractMergeTreeNode) {
                if (((AbstractMergeTreeNode)object).getValue() > ((AbstractMergeTreeNode)object2).getValue()) {
                    return -1;
                }
                if (((AbstractMergeTreeNode)object).getValue() < ((AbstractMergeTreeNode)object2).getValue()) {
                    return 1;
                }
                if (((AbstractMergeTreeNode)object).getID() < ((AbstractMergeTreeNode)object2).getID()) {
                    return -1;
                }
                if (((AbstractMergeTreeNode)object).getID() > ((AbstractMergeTreeNode)object2).getID()) {
                    return 1;
                }
            }
            return 0;
        }
    }

    public static class ComparatorValueAscending
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof AbstractMergeTreeNode && object2 instanceof AbstractMergeTreeNode) {
                if (((AbstractMergeTreeNode)object).getValue() > ((AbstractMergeTreeNode)object2).getValue()) {
                    return 1;
                }
                if (((AbstractMergeTreeNode)object).getValue() < ((AbstractMergeTreeNode)object2).getValue()) {
                    return -1;
                }
                if (((AbstractMergeTreeNode)object).getID() < ((AbstractMergeTreeNode)object2).getID()) {
                    return 1;
                }
                if (((AbstractMergeTreeNode)object).getID() > ((AbstractMergeTreeNode)object2).getID()) {
                    return -1;
                }
            }
            return 0;
        }
    }
}

