/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.highprecision;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.highprecision.DoubleComplexComputer;
import jdplus.toolkit.base.core.math.highprecision.DoubleDouble;
import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleComputer;
import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleType;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class DoubleComplex {
    public static final DoubleComplex ZERO = new DoubleComplex(0.0, 0.0, 0.0, 0.0);
    public static final DoubleComplex ONE = new DoubleComplex(1.0, 0.0, 0.0, 0.0);
    public static final DoubleComplex I = new DoubleComplex(0.0, 0.0, 1.0, 0.0);
    private final double reHigh;
    private final double reLow;
    private final double imHigh;
    private final double imLow;

    public static DoubleComplex of(Complex c) {
        return new DoubleComplex(c.getRe(), 0.0, c.getIm(), 0.0);
    }

    public static DoubleComplex cart(double re, double im) {
        return new DoubleComplex(re, 0.0, im, 0.0);
    }

    public static DoubleComplex cart(DoubleDoubleType re, DoubleDoubleType im) {
        return new DoubleComplex(re.getHigh(), re.getLow(), im.getHigh(), im.getLow());
    }

    public DoubleDouble getRe() {
        return new DoubleDouble(this.reHigh, this.reLow);
    }

    public DoubleDouble getIm() {
        return new DoubleDouble(this.imHigh, this.imLow);
    }

    public DoubleDouble absSquare() {
        DoubleDoubleComputer re = new DoubleDoubleComputer(this.reHigh, this.reLow);
        DoubleDoubleComputer im = new DoubleDoubleComputer(this.imHigh, this.imLow);
        return re.square().add(im.square()).result();
    }

    public DoubleDouble abs() {
        DoubleDoubleComputer re = new DoubleDoubleComputer(this.reHigh, this.reLow);
        DoubleDoubleComputer im = new DoubleDoubleComputer(this.imHigh, this.imLow);
        return re.square().add(im.square()).sqrt().result();
    }

    public DoubleComplex plus(DoubleComplex c) {
        return new DoubleComplexComputer(this).add(c).result();
    }

    public DoubleComplex minus(DoubleComplex c) {
        return new DoubleComplexComputer(this).sub(c).result();
    }

    public DoubleComplex times(DoubleComplex c) {
        return new DoubleComplexComputer(this).mul(c).result();
    }

    public DoubleComplex dividedBy(DoubleComplex c) {
        return new DoubleComplexComputer(this).div(c).result();
    }

    public DoubleComplex plus(Complex c) {
        return new DoubleComplexComputer(this).add(DoubleComplex.of(c)).result();
    }

    public DoubleComplex minus(Complex c) {
        return new DoubleComplexComputer(this).sub(DoubleComplex.of(c)).result();
    }

    public DoubleComplex times(Complex c) {
        return new DoubleComplexComputer(this).mul(DoubleComplex.of(c)).result();
    }

    public DoubleComplex dividedBy(Complex c) {
        return new DoubleComplexComputer(this).div(DoubleComplex.of(c)).result();
    }

    public DoubleComplex plus(DoubleDouble r) {
        return new DoubleComplexComputer(this).add(r).result();
    }

    public DoubleComplex minus(DoubleDouble r) {
        return new DoubleComplexComputer(this).sub(r).result();
    }

    public DoubleComplex times(DoubleDouble r) {
        return new DoubleComplexComputer(this).mul(r).result();
    }

    public DoubleComplex dividedBy(DoubleDouble r) {
        return new DoubleComplexComputer(this).div(r).result();
    }

    public DoubleComplex plus(double r) {
        return new DoubleComplexComputer(this).add(r).result();
    }

    public DoubleComplex minus(double r) {
        return new DoubleComplexComputer(this).sub(r).result();
    }

    public DoubleComplex times(double r) {
        return new DoubleComplexComputer(this).mul(r).result();
    }

    public DoubleComplex dividedBy(double r) {
        return new DoubleComplexComputer(this).mul(r).result();
    }

    public Complex asComplex() {
        return Complex.cart((double)(this.reHigh + this.reLow), (double)(this.imHigh + this.imLow));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(");
        result.append(this.getRe());
        DoubleDouble im = this.getIm();
        if (im.isNegative()) {
            result.append(" - ").append(im.negate());
        } else if (im.isZero()) {
            result.append(" - ").append(0.0);
        } else {
            result.append(" + ").append(im);
        }
        result.append("i)");
        return result.toString();
    }

    @Generated
    public DoubleComplex(double reHigh, double reLow, double imHigh, double imLow) {
        this.reHigh = reHigh;
        this.reLow = reLow;
        this.imHigh = imHigh;
        this.imLow = imLow;
    }

    @Generated
    public double getReHigh() {
        return this.reHigh;
    }

    @Generated
    public double getReLow() {
        return this.reLow;
    }

    @Generated
    public double getImHigh() {
        return this.imHigh;
    }

    @Generated
    public double getImLow() {
        return this.imLow;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleComplex)) {
            return false;
        }
        DoubleComplex other = (DoubleComplex)o;
        if (Double.compare(this.getReHigh(), other.getReHigh()) != 0) {
            return false;
        }
        if (Double.compare(this.getReLow(), other.getReLow()) != 0) {
            return false;
        }
        if (Double.compare(this.getImHigh(), other.getImHigh()) != 0) {
            return false;
        }
        return Double.compare(this.getImLow(), other.getImLow()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $reHigh = Double.doubleToLongBits(this.getReHigh());
        result = result * 59 + (int)($reHigh >>> 32 ^ $reHigh);
        long $reLow = Double.doubleToLongBits(this.getReLow());
        result = result * 59 + (int)($reLow >>> 32 ^ $reLow);
        long $imHigh = Double.doubleToLongBits(this.getImHigh());
        result = result * 59 + (int)($imHigh >>> 32 ^ $imHigh);
        long $imLow = Double.doubleToLongBits(this.getImLow());
        result = result * 59 + (int)($imLow >>> 32 ^ $imLow);
        return result;
    }
}

