/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp;

import internal.toolkit.base.tsp.DefaultTsMeta;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import jdplus.toolkit.base.tsp.util.ObsFormat;
import lombok.NonNull;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import org.jspecify.annotations.Nullable;

public interface TsMeta<T> {
    @Deprecated
    public static final TsMeta<String> SOURCE_OLD = TsMeta.onString("tsmoniker.source");
    @Deprecated
    public static final TsMeta<String> ID_OLD = TsMeta.onString("tsmoniker.id");
    @Deprecated
    public static final TsMeta<String> DYNAMIC = TsMeta.onString("dynamic");
    public static final TsMeta<LocalDateTime> BEG = TsMeta.onDateTime("@beg", "yyyy-MM-dd", Locale.ROOT);
    public static final TsMeta<LocalDateTime> END = TsMeta.onDateTime("@end", "yyyy-MM-dd", Locale.ROOT);
    public static final TsMeta<?> CONFIDENTIAL = TsMeta.onString("@confidential");
    public static final TsMeta<String> DESCRIPTION = TsMeta.onString("@description");
    public static final TsMeta<String> OWNER = TsMeta.onString("@owner");
    public static final TsMeta<String> SOURCE = TsMeta.onString("@source");
    public static final TsMeta<String> ID = TsMeta.onString("@id");
    public static final TsMeta<LocalDateTime> TIMESTAMP = TsMeta.onTimestamp();
    public static final TsMeta<?> DOCUMENT = TsMeta.onString("@document");
    public static final TsMeta<?> SUMMARY = TsMeta.onString("@summary");
    public static final TsMeta<String> NOTE = TsMeta.onString("@note");
    public static final TsMeta<?> TODO = TsMeta.onString("@todo");
    public static final TsMeta<?> ALGORITHM = TsMeta.onString("@algorithm");
    public static final TsMeta<?> QUALITY = TsMeta.onString("@quality");

    @NonNull
    public String getKey();

    public @Nullable T load(@NonNull Function<String, String> var1);

    default public @Nullable T load(@NonNull Map<String, String> meta) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        return this.load(meta::get);
    }

    public void store(@NonNull BiConsumer<String, String> var1, @NonNull T var2);

    default public void store(@NonNull Map<String, String> meta, @NonNull T value) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.store(meta::put, value);
    }

    @NonNull
    public static <T> TsMeta<T> on(@NonNull String key, @NonNull Parser<T> parser, @NonNull Formatter<T> formatter) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return new DefaultTsMeta<T>(key, parser, formatter);
    }

    @NonNull
    public static TsMeta<String> onString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new DefaultTsMeta<String>(key, Parser.onString(), Formatter.onString());
    }

    @NonNull
    public static TsMeta<LocalDateTime> onDateTime(@NonNull String key, @NonNull String datePattern, @NonNull Locale locale) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (datePattern == null) {
            throw new NullPointerException("datePattern is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        ObsFormat obsFormat = ObsFormat.builder().locale(locale).dateTimePattern(datePattern).build();
        return new DefaultTsMeta<LocalDateTime>(key, obsFormat.dateTimeParser(), obsFormat.dateTimeFormatter());
    }

    @NonNull
    public static TsMeta<LocalDateTime> onTimestamp() {
        DateTimeFormatter main = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        ObsFormat legacy = ObsFormat.builder().dateTimePattern("EEE MMM dd HH:mm:ss zzz yyyy").build();
        return new DefaultTsMeta<LocalDateTime>("@timestamp", Parser.onDateTimeFormatter((DateTimeFormatter)main, (TemporalQuery[])new TemporalQuery[]{LocalDateTime::from}).orElse(legacy.dateTimeParser()), Formatter.onDateTimeFormatter((DateTimeFormatter)main));
    }
}

