/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.core;

import java.time.LocalDate;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.xml.legacy.IXmlConverter;

@XmlType(name="TsPeriodType")
public class XmlTsPeriod
implements IXmlConverter<TsPeriod> {
    static final String NAME = "TsPeriodType";
    @XmlElement(name="Frequency")
    public int freq;
    @XmlElement(name="Year")
    public int year;
    @XmlElement(name="Period")
    public Integer period;

    @Override
    public void copy(TsPeriod t) {
        this.freq = t.getUnit().getAnnualFrequency();
        this.period = this.freq != 1 ? Integer.valueOf(t.annualPosition() + 1) : null;
        this.year = t.year();
    }

    @Override
    public TsPeriod create() {
        return XmlTsPeriod.of(this.freq, this.year, this.period);
    }

    public static TsPeriod of(int f, int y, Integer P) {
        int p = P == null ? 1 : P;
        switch (f) {
            case 1: {
                return TsPeriod.yearly((int)y);
            }
            case 4: {
                return TsPeriod.quarterly((int)y, (int)p);
            }
            case 12: {
                return TsPeriod.monthly((int)y, (int)p);
            }
        }
        return TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)f), (LocalDate)LocalDate.of(y, p * 12 / f, 1));
    }
}

