/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifdef H5_HAVE_C11_THREADS
#define H5TS_key_set_value(key, value) (H5_UNLIKELY(tss_set((key), (value)) != thrd_success) ? FAIL : SUCCEED)
#define H5TS_key_get_value(key, value) (*(value) = tss_get(key), SUCCEED)

#else
#ifdef H5_HAVE_WIN_THREADS

static inline herr_t
H5TS_key_set_value(H5TS_key_t key, void *value)
{
    
    if (H5_UNLIKELY(0 == TlsSetValue(key, (LPVOID)value)))
        return FAIL;

    return SUCCEED;
} 

static inline herr_t
H5TS_key_get_value(H5TS_key_t key, void **value)
{
    
    if (H5_UNLIKELY(NULL == (*value = TlsGetValue(key))))
        
        if (H5_UNLIKELY(ERROR_SUCCESS != GetLastError()))
            return FAIL;

    return SUCCEED;
} 

#else

#define H5TS_key_set_value(key, value) (H5_UNLIKELY(pthread_setspecific((key), (value))) ? FAIL : SUCCEED)
#define H5TS_key_get_value(key, value) (*(value) = pthread_getspecific(key), SUCCEED)

#endif
#endif
