## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 6,
  fig.align = "center"
)

## ----setup, message=F---------------------------------------------------------
library(VIM)
dataset <- sleep[, c("Dream", "NonD", "BodyWgt", "Span")] # dataset with missings
dataset$BodyWgt <- log(dataset$BodyWgt)
dataset$Span <- log(dataset$Span)
imp_knn <- kNN(dataset) # dataset with imputed values

## -----------------------------------------------------------------------------
aggr(dataset) 
aggr(imp_knn, delimiter = "_imp") 

## -----------------------------------------------------------------------------
# for missing values
x <- sleep[, c("Exp", "NonD", "Sleep")]
barMiss(x, only.miss = FALSE)
# for imputed values
x_IMPUTED <- regressionImp(NonD ~ Sleep, data = x)
barMiss(x_IMPUTED, delimiter = "_imp", only.miss = FALSE)

## -----------------------------------------------------------------------------
dataset <- sleep[, c("Span", "NonD","Sleep")]
# for missing values
scattMiss(dataset[,-3])
# for imputed values
imp_regression <- regressionImp(NonD ~ Sleep, dataset)
scattMiss(imp_regression[,-3], delimiter = "_imp")

## -----------------------------------------------------------------------------

## for missing values
x <- sleep[, c("Span", "NonD","Sleep")]
histMiss(x, only.miss = FALSE)
# for imputed values
x_IMPUTED  <- regressionImp(NonD ~ Sleep, data = x)
histMiss(x_IMPUTED, delimiter = "_imp", only.miss = FALSE)


## ----warning=FALSE------------------------------------------------------------
x <- sleep[, c("Dream", "NonD","Sleep", "BodyWgt")]
x$BodyWgt <- log(x$BodyWgt)
# for missing values
matrixplot(x, sortby="BodyWgt")
# for imputed values - multiple variable imputation with regrssionImp()
x_IMPUTED  <- regressionImp(NonD + Dream ~ Sleep, data = x)
matrixplot(x_IMPUTED, delimiter = "_imp", sortby = "BodyWgt")

## -----------------------------------------------------------------------------
dataset <- sleep[, c("Dream", "NonD", "BodyWgt", "Span")]
dataset$BodyWgt <- log(dataset$BodyWgt)
dataset$Span <- log(dataset$Span)
imp_knn <- kNN(dataset, variable = "NonD") 
dataset[, c("NonD", "Span")] |> 
  marginplot()
imp_knn[, c("NonD", "Span", "NonD_imp")] |> 
  marginplot(delimiter = "_imp")

## ----warning=FALSE------------------------------------------------------------
## for missing values
x <- sleep[, 2:4]
x[, 1] <- log10(x[, 1])
marginmatrix(x)

## for imputed values
x_imp <- irmi(sleep[, 2:4])
x_imp[,1] <- log10(x_imp[, 1])
marginmatrix(x_imp, delimiter = "_imp")

## ----results=FALSE, fig.width = 7,  fig.height=6------------------------------
dataset <- sleep[, c("Dream", "NonD", "BodyWgt", "Span")] # dataset with missings

# for missing values
dataset$BodyWgt <- log(dataset$BodyWgt)
dataset$Span <- log(dataset$Span)

pbox(dataset)


## ----results=FALSE, fig.width = 7,  fig.height=6------------------------------
# for imputed values
pbox(kNN(dataset), delimiter = "_imp")


## ----results=FALSE, fig.height=4----------------------------------------------
dataset <- sleep[, c("Dream", "NonD", "BodyWgt", "Span")] # dataset with missings

## for missing values
parcoordMiss(dataset, plotvars=2:4, interactive = FALSE)
legend("top", col = c("skyblue", "red"), lwd = c(1,1),
       legend = c("observed in Dream", "missing in Dream"))


## ----results=FALSE, fig.height=4----------------------------------------------
## for imputed values
parcoordMiss(kNN(dataset), plotvars=2:4, delimiter = "_imp" , 
             interactive = FALSE)
legend("top", col = c("skyblue", "orange"), lwd = c(1,1),
       legend = c("observed in Dream", "imputed in Dream"))


## ----fig.height=4-------------------------------------------------------------
data(sleep, package = "VIM") # dataset with missings
table(sleep$Exp) # categorical variable of interest

## for missing values
spineMiss(sleep[, c("Exp", "Sleep")])

## ----results=FALSE , fig.height=4---------------------------------------------
## for imputed values
spineMiss(kNN(sleep[, c("Exp", "Sleep")]), delimiter = "_imp")

## ----results=FALSE , fig.height=5---------------------------------------------
## for missing values
# using the three categorical variables Pred, Exp and Danger
mosaicMiss(sleep, highlight = 4, plotvars = 8:10, miss.labels = FALSE) 

## ----results=FALSE , fig.height=5---------------------------------------------
## for imputed values
mosaicMiss(kNN(sleep), highlight = 4, plotvars = 8:10, delimiter = "_imp",
           miss.labels = FALSE)

## ----message=FALSE, warning=FALSE, fig.height=5-------------------------------
## for missing values
x <- sleep[, 1:5]
x[,c(1,2,4)] <- log10(x[,c(1,2,4)])
scattmatrixMiss(x, highlight = "Dream")

## ----message=FALSE,warning=FALSE, fig.height=5--------------------------------
## for imputed values
x_imp <- kNN(sleep[, 1:5])
x_imp[,c(1,2,4)] <- log10(x_imp[,c(1,2,4)])
scattmatrixMiss(x_imp, delimiter = "_imp", highlight = "Dream")

## ----message=FALSE, fig.height=4----------------------------------------------
## for missing values
scattJitt(sleep[, c("Dream", "Span")])

## ----results=FALSE, fig.height=4----------------------------------------------
## for imputed values
scattJitt(kNN(sleep[, c("Dream", "Span")]), delimiter = "_imp")

## ----results=FALSE, fig.height=5, warning=FALSE-------------------------------
x <- sleep[, -(8:10)]
x[,c(1,2,4,6,7)] <- log10(x[,c(1,2,4,6,7)])
pairsVIM(x)

## -----------------------------------------------------------------------------
p <- c(0, 0.3, 0.55, 0.8, 1)

## HCL colors
colSequence(p, c(0, 0, 100), c(0, 100, 50))
colSequence(p, polarLUV(L=90, C=30, H=90), c(0, 100, 50))

## -----------------------------------------------------------------------------
## RGB colors
colSequence(p, c(1, 1, 1), c(1, 0, 0), space="rgb")
colSequence(p, RGB(1, 1, 0), "red")

## ----fig.height=4-------------------------------------------------------------
## for missing values
x <- sleep[, "Dream"]
y <- sleep[, "Span"]
plot(x, y)
rugNA(x, y, side = 1)
rugNA(x, y, side = 2)

## ----results=FALSE, fig.height=4----------------------------------------------
## for imputed values
x_imp <- kNN(sleep[, c("Dream","Span")])
x <- x_imp[, "Dream"]
y <- x_imp[, "Span"]
miss <- x_imp[, c("Dream_imp","Span_imp")]
plot(x, y)
rugNA(x, y, side = 1, col = "orange", miss = miss)
rugNA(x, y, side = 2, col = "orange", miss = miss)


## -----------------------------------------------------------------------------
alphablend("red", 0.6)

