## ----loadlib, echo = TRUE, results = 'hide', message=FALSE, warning=FALSE-----
library(KinformR)

show <- function(df){
  knitr::kable(df, format = "markdown", digits = 2)
}


## -----------------------------------------------------------------------------
mat.name1<-system.file('extdata/1234_ex2.mat', package = 'KinformR')
rel.mat <- read.relation.mat(mat.name1)
show(rel.mat)

## -----------------------------------------------------------------------------

tsv.name1<-system.file('extdata/1234_ex2.tsv', package = 'KinformR')
status.df <- read.indiv(tsv.name1)

show(status.df)

## -----------------------------------------------------------------------------

full.df.status <-  score.variant.status(status.df)
show(full.df.status)

## -----------------------------------------------------------------------------

ex.score.default <- score.fam(rel.mat, full.df.status)
show(ex.score.default)

## -----------------------------------------------------------------------------

ex.score.sum <- score.fam(rel.mat, full.df.status,
                          return.sums = TRUE, return.means = FALSE)
show(ex.score.sum)

## -----------------------------------------------------------------------------

ex.score.table <- score.fam(rel.mat, full.df.status,
                            return.sums = FALSE, return.means = FALSE)
show(ex.score.table)

## -----------------------------------------------------------------------------
rel.mat.proband <-  rel.mat["MS-1234-1001",]
show(rel.mat.proband)

## -----------------------------------------------------------------------------
name.stat.dict <- full.df.status$statvar.cat
names(name.stat.dict) <- full.df.status$name
name.stat.dict

## -----------------------------------------------------------------------------
rel.dict<-build.relation.dict(rel.mat.proband, name.stat.dict)
rel.dict

## -----------------------------------------------------------------------------
rel.dict$A.c

## -----------------------------------------------------------------------------
rel.dict$U.i

## -----------------------------------------------------------------------------
for(i in 0:7){
    print(paste0("Degree of relatedness: ", i,
                 " coefficient of relatedness: ",  1 / (2 ** (i))))
}

## -----------------------------------------------------------------------------
calc.rv.score(rel.dict)

## -----------------------------------------------------------------------------
calc.rv.score(rel.dict, unaffected.weight=0)

