/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk.sqrt;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.ElementaryTransformations;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.akf.AugmentedState;
import jdplus.toolkit.base.core.ssf.dk.DiffuseUpdateInformation;
import jdplus.toolkit.base.core.ssf.dk.sqrt.IDiffuseSquareRootFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.OrdinaryFilter;

public class DiffuseSquareRootInitializer
implements OrdinaryFilter.Initializer {
    private Transformation fn = (row, A) -> ElementaryTransformations.fastRowGivens(row, A);
    private final IDiffuseSquareRootFilteringResults results;
    private AugmentedState astate;
    private DiffuseUpdateInformation updateInfo;
    private ISsf ssf;
    private ISsfLoading loading;
    private ISsfError error;
    private ISsfDynamics dynamics;
    private ISsfData data;
    private int t;
    private int endpos;
    private DataBlock Z;
    private double scale;

    public DiffuseSquareRootInitializer() {
        this.results = null;
    }

    public DiffuseSquareRootInitializer(IDiffuseSquareRootFilteringResults results) {
        this.results = results;
    }

    public Transformation getTransformation() {
        return this.fn;
    }

    public void setTransformation(Transformation fn) {
        this.fn = fn;
    }

    @Override
    public int initializeFilter(State state, ISsf ssf, ISsfData data) {
        if (!ssf.initialization().isDiffuse()) {
            ssf.initialization().a0(state.a());
            ssf.initialization().Pf0(state.P());
            return 0;
        }
        this.ssf = ssf;
        this.loading = ssf.loading();
        this.error = ssf.measurementError();
        this.dynamics = ssf.dynamics();
        this.data = data;
        this.scale = data.scale();
        this.t = 0;
        int end = data.length();
        if (!this.initState()) {
            return -1;
        }
        while (this.t < end) {
            if (this.results != null) {
                this.results.save(this.t, this.astate, StateInfo.Forecast);
            }
            if (this.error(this.t)) {
                if (this.results != null) {
                    this.results.save(this.t, this.updateInfo);
                }
                this.update();
            } else if (this.results != null) {
                this.results.save(this.t, this.updateInfo);
            }
            if (this.results != null) {
                this.results.save(this.t, this.astate, StateInfo.Concurrent);
            }
            if (!this.astate.isDiffuse()) break;
            this.astate.next(this.t++, this.dynamics);
        }
        if (this.t >= end) {
            throw new SsfException("Diffuse initialization failed");
        }
        state.P().copy(this.astate.P());
        state.a().copy(this.astate.a());
        state.next(this.t++, this.dynamics);
        if (this.results != null) {
            this.results.close(this.t);
        }
        this.endpos = this.t;
        return this.t;
    }

    public int getEndDiffusePos() {
        return this.endpos;
    }

    private boolean initState() {
        ISsfInitialization initialization = this.ssf.initialization();
        int r = initialization.getStateDim();
        this.astate = AugmentedState.of(this.ssf);
        if (this.astate == null) {
            return false;
        }
        this.updateInfo = new DiffuseUpdateInformation(r);
        this.Z = DataBlock.make(this.astate.getDiffuseDim());
        initialization.diffuseConstraints(this.constraints());
        return true;
    }

    private void update() {
        if (this.updateInfo.isDiffuse()) {
            this.update1();
        } else {
            this.update0();
        }
    }

    private void update0() {
        double f = this.updateInfo.getVariance();
        if (f != 0.0) {
            double e = this.updateInfo.get();
            DataBlock C = this.updateInfo.M();
            FastMatrix P = this.astate.P();
            P.addXaXt(-1.0 / f, C);
            double c = e / f;
            this.astate.a().addAY(c, C);
        }
    }

    private void update1() {
        double f = this.updateInfo.getVariance();
        double fi = this.updateInfo.getDiffuseVariance();
        double e = this.updateInfo.get();
        DataBlock C = this.updateInfo.M();
        DataBlock Ci = this.updateInfo.Mi();
        if (f != 0.0) {
            this.astate.P().addXaXt(-1.0 / f, C);
            DataBlock tmp = DataBlock.of((DoubleSeq)C);
            tmp.addAY(-f / fi, Ci);
            this.astate.P().addXaXt(1.0 / f, tmp);
        }
        this.astate.a().addAY(e / fi, Ci);
    }

    private boolean error(int t) {
        this.preArray();
        DataBlock z = this.zconstraints();
        double fi = z.ssq();
        if (fi < 1.0E-9) {
            fi = 0.0;
        }
        this.updateInfo.setDiffuseVariance(fi);
        double f = this.loading.ZVZ(t, this.astate.P());
        if (this.error != null) {
            f += this.error.at(t);
        }
        if (Math.abs(f) < 1.0E-9) {
            f = 0.0;
        }
        this.updateInfo.setVariance(f);
        double y = this.data.get(t);
        if (Double.isNaN(y)) {
            this.updateInfo.setMissing();
            return false;
        }
        double e = y - this.loading.ZX(t, this.astate.a());
        if (Math.abs(e) < this.scale * 1.0E-9) {
            e = 0.0;
        }
        if (fi == 0.0 && f == 0.0 && e != 0.0) {
            throw new SsfException("Inconsistent constraints in the model");
        }
        this.updateInfo.set(e, this.data.isConstraint(t));
        DataBlock C = this.updateInfo.M();
        this.loading.ZM(t, this.astate.P(), C);
        if (this.updateInfo.isDiffuse()) {
            FastMatrix B = this.constraints();
            this.fn.transform(z, B);
            this.updateInfo.Mi().setAY(z.get(0), B.column(0));
            this.updateInfo.Mi().apply(x -> Math.abs(x) < 1.0E-9 ? 0.0 : x);
            this.astate.dropDiffuseConstraint();
        }
        return true;
    }

    private void preArray() {
        DataBlock zconstraints = this.zconstraints();
        zconstraints.set(0.0);
        FastMatrix A = this.constraints();
        this.loading.ZM(this.t, A, zconstraints);
    }

    private FastMatrix constraints() {
        return this.astate.B();
    }

    private DataBlock zconstraints() {
        return this.Z.range(0, this.astate.getDiffuseDim());
    }

    public static interface Transformation {
        public void transform(DataBlock var1, FastMatrix var2);
    }
}

