/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import java.util.function.DoublePredicate;
import jdplus.toolkit.base.core.math.matrices.DataPointer;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public final class RPointer
extends DataPointer {
    final int inc;

    public RPointer(double[] storage, int pos, int inc) {
        super(storage, pos);
        this.inc = inc;
    }

    @Override
    public int inc() {
        return this.inc;
    }

    @Override
    public double value(int n) {
        return this.p[this.pos + n * this.inc];
    }

    @Override
    public double dot(int n, DataPointer x) {
        int xinc = x.inc();
        double s = 0.0;
        int imax = this.pos + n;
        int i = this.pos;
        int j = x.pos;
        while (i != imax) {
            s += this.p[i] * x.p[j];
            i += this.inc;
            j += xinc;
        }
        return s;
    }

    @Override
    public void addAX(int n, double a, DataPointer x) {
        int xinc = x.inc();
        int imax = this.pos + n * this.inc;
        int i = this.pos;
        int j = x.pos;
        while (i != imax) {
            int n2 = i;
            this.p[n2] = this.p[n2] + a * x.p[j];
            i += this.inc;
            j += xinc;
        }
    }

    public double dot(int n, RPointer x) {
        int imax = this.pos + n * this.inc;
        double s = 0.0;
        int i = this.pos;
        int j = x.pos;
        while (i != imax) {
            s += this.p[i] * x.p[j];
            i += this.inc;
            j += x.inc;
        }
        return s;
    }

    @Override
    public boolean test(int n, DoublePredicate pred) {
        int imax = this.pos + n * this.inc;
        for (int i = this.pos; i != imax; i += this.inc) {
            if (pred.test(this.p[i])) continue;
            return false;
        }
        return true;
    }

    public void add(int n, RPointer x) {
        int imax = this.pos + n * this.inc;
        int i = this.pos;
        int j = x.pos;
        while (i != imax) {
            int n2 = i;
            this.p[n2] = this.p[n2] + x.p[j];
            i += this.inc;
            j += x.inc;
        }
    }

    public void sub(int n, RPointer x) {
        int imax = this.pos + n * this.inc;
        int i = this.pos;
        int j = x.pos;
        while (i != imax) {
            int n2 = i;
            this.p[n2] = this.p[n2] - x.p[j];
            i += this.inc;
            j += x.inc;
        }
    }

    public void copy(int n, RPointer x) {
        int imax = this.pos + n * this.inc;
        int i = this.pos;
        int j = x.pos;
        while (i != imax) {
            this.p[i] = x.p[j];
            i += this.inc;
            j += x.inc;
        }
    }

    @Override
    public void mul(int n, double a) {
        int imax = this.pos + n * this.inc;
        for (int i = this.pos; i != imax; i += this.inc) {
            int n2 = i;
            this.p[n2] = this.p[n2] * a;
        }
    }

    @Override
    public void div(int n, double a) {
        int imax = this.pos + n * this.inc;
        for (int i = this.pos; i != imax; i += this.inc) {
            int n2 = i;
            this.p[n2] = this.p[n2] / a;
        }
    }

    @Override
    public void add(int n, double a) {
        int imax = this.pos + n * this.inc;
        for (int i = this.pos; i != imax; i += this.inc) {
            int n2 = i;
            this.p[n2] = this.p[n2] + a;
        }
    }

    @Override
    public void set(int n, double a) {
        int imax = this.pos + n * this.inc;
        for (int i = this.pos; i != imax; i += this.inc) {
            this.p[i] = a;
        }
    }

    @Override
    public void chs(int n) {
        int imax = this.pos + n * this.inc;
        for (int i = this.pos; i != imax; i += this.inc) {
            this.p[i] = -this.p[i];
        }
    }

    @Override
    public double asum(int n) {
        double rslt = 0.0;
        int jmax = this.pos + n * this.inc;
        for (int j = this.pos; j != jmax; j += this.inc) {
            rslt += Math.abs(this.p[j]);
        }
        return rslt;
    }

    @Override
    public double sum(int n) {
        double rslt = 0.0;
        int jmax = this.pos + n * this.inc;
        for (int j = this.pos; j != jmax; j += this.inc) {
            rslt += this.p[j];
        }
        return rslt;
    }

    @Override
    public double ssq(int n) {
        double d = 0.0;
        int imax = this.pos + n * this.inc;
        for (int i = this.pos; i != imax; i += this.inc) {
            double cur = this.p[i];
            d += cur * cur;
        }
        return d;
    }

    public void swap(int n, RPointer x) {
        int imax = this.pos + n * this.inc;
        int i = this.pos;
        int j = x.pos;
        while (i < imax) {
            double tmp = this.p[i];
            this.p[i] = x.p[j];
            this.p[j] = tmp;
            i += this.inc;
            j += x.inc;
        }
    }

    @Generated
    public @NonNull String toString() {
        return "RPointer(inc=" + this.inc + ")";
    }
}

