/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.xmlss;

import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.helpers.ArrayBook;
import ec.util.spreadsheet.xmlss.XmlssContentException;
import ec.util.spreadsheet.xmlss.XmlssFormatException;
import ec.util.spreadsheet.xmlss.XmlssSheetBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import lombok.NonNull;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import standalone_spreadsheet.nbbrd.io.WrappedIOException;
import standalone_spreadsheet.nbbrd.io.function.IOFunction;
import standalone_spreadsheet.nbbrd.io.xml.Sax;

final class XmlssBookReader {
    private XmlssBookReader() {
    }

    @NonNull
    public static ArrayBook parseFile(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return XmlssBookReader.parse(o -> (ArrayBook)o.parseFile(file));
    }

    @NonNull
    public static ArrayBook parseStream(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        return XmlssBookReader.parse(o -> (ArrayBook)o.parseStream(stream));
    }

    private static ArrayBook parse(Loader loader) throws IOException {
        BookSax2EventHandler handler = new BookSax2EventHandler();
        try {
            return (ArrayBook)loader.applyWithIO(Sax.Parser.of(handler, handler::build));
        }
        catch (WrappedIOException ex) {
            Throwable cause = ex.getCause();
            if (XmlssBookReader.isTrailingSectionContentNotAllowed(cause, handler.isEndWorkbookNotified())) {
                return handler.build();
            }
            if (cause instanceof MissingHeaderException) {
                throw new XmlssContentException(((MissingHeaderException)cause).getMessage());
            }
            if (cause instanceof SAXParseException) {
                throw new XmlssFormatException(cause);
            }
            throw ex;
        }
    }

    private static boolean isTrailingSectionContentNotAllowed(Throwable cause, boolean endWorkbookNotified) {
        return cause instanceof SAXException && endWorkbookNotified;
    }

    private static interface Loader
    extends IOFunction<Sax.Parser<ArrayBook>, ArrayBook> {
    }

    static final class BookSax2EventHandler
    extends DefaultHandler {
        private static final String SS_URI = "urn:schemas-microsoft-com:office:spreadsheet";
        private static final String WORKBOOK_TAG = "Workbook";
        private static final String WORKSHEET_TAG = "Worksheet";
        private static final String ROW_TAG = "Row";
        private static final String CELL_TAG = "Cell";
        private static final String DATA_TAG = "Data";
        private final ArrayBook.Builder result = ArrayBook.builder();
        private int rowNum = -1;
        private int colNum = -1;
        private String dataType = null;
        private String text = null;
        private final XmlssSheetBuilder builder = XmlssSheetBuilder.create();
        private boolean endWorkbookNotified = false;
        private boolean headerFound = false;
        private Locator locator = null;

        public boolean isEndWorkbookNotified() {
            return this.endWorkbookNotified;
        }

        public ArrayBook build() {
            return this.result.build();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (!this.headerFound) {
                this.headerFound = "mso-application".equals(target) && "progid=\"Excel.Sheet\"".equals(data);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.headerFound) {
                throw new MissingHeaderException(this.locator);
            }
            switch (qName) {
                case "Worksheet": {
                    this.builder.name(attributes.getValue(SS_URI, "Name"));
                    break;
                }
                case "Row": {
                    String tmpRow = attributes.getValue(SS_URI, "Index");
                    this.rowNum = tmpRow != null ? Integer.parseInt(tmpRow) - 1 : this.rowNum + 1;
                    break;
                }
                case "Cell": {
                    String tmpCol = attributes.getValue(SS_URI, "Index");
                    this.colNum = tmpCol != null ? Integer.parseInt(tmpCol) - 1 : this.colNum + 1;
                    break;
                }
                case "Data": {
                    this.dataType = attributes.getValue(SS_URI, "Type");
                    this.text = "";
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (qName) {
                case "Workbook": {
                    this.endWorkbookNotified = true;
                    break;
                }
                case "Worksheet": {
                    this.result.sheet((Sheet)this.builder.build());
                    this.rowNum = -1;
                    this.builder.clear();
                    break;
                }
                case "Row": {
                    this.colNum = -1;
                    break;
                }
                case "Cell": {
                    this.dataType = null;
                    break;
                }
                case "Data": {
                    this.builder.put(this.text, this.dataType, this.rowNum, this.colNum);
                    this.text = null;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text = this.text + new String(ch, start, length);
            }
        }
    }

    private static final class MissingHeaderException
    extends SAXException {
        public MissingHeaderException(Locator locator) {
            super(MissingHeaderException.newMessage(locator));
        }

        static String newMessage(Locator locator) {
            String result = "Missing header";
            if (locator != null && locator.getSystemId() != null) {
                result = result + " in " + locator.getSystemId();
            }
            return result;
        }
    }
}

