/*
 * Decompiled with CFR 0.152.
 */
package internal.spreadsheet.base.api.legacy;

import internal.spreadsheet.base.api.SpreadSheetParam;
import internal.spreadsheet.base.api.legacy.LegacySpreadSheetId;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import jdplus.spreadsheet.base.api.SpreadSheetBean;
import jdplus.toolkit.base.api.design.DemetraPlusLegacy;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataMoniker;
import jdplus.toolkit.base.tsp.legacy.LegacyFileId;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import lombok.Generated;
import lombok.NonNull;

@DemetraPlusLegacy
public final class LegacySpreadSheetMoniker
implements HasDataMoniker {
    private final String providerName;
    private final SpreadSheetParam param;

    @NonNull
    public TsMoniker toMoniker(@NonNull DataSource dataSource) throws IllegalArgumentException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        throw new IllegalArgumentException("Not supported yet.");
    }

    @NonNull
    public TsMoniker toMoniker(@NonNull DataSet dataSet) throws IllegalArgumentException {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)dataSet);
        throw new IllegalArgumentException("Not supported yet.");
    }

    @NonNull
    public Optional<DataSource> toDataSource(@NonNull TsMoniker moniker) throws IllegalArgumentException {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (TsMoniker)moniker);
        LegacyFileId id = LegacyFileId.parse((String)moniker.getId());
        return id != null ? Optional.of(this.toDataSource(Path.of(id.getFile(), new String[0]).toFile())) : Optional.empty();
    }

    @NonNull
    public Optional<DataSet> toDataSet(@NonNull TsMoniker moniker) throws IllegalArgumentException {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (TsMoniker)moniker);
        LegacySpreadSheetId id = LegacySpreadSheetId.parse(moniker.getId());
        return id != null ? Optional.of(this.toDataSet(id)) : Optional.empty();
    }

    private DataSet toDataSet(LegacySpreadSheetId id) {
        DataSource source = this.toDataSource(Path.of(id.getFile(), new String[0]).toFile());
        if (id.isCollection()) {
            DataSet.Builder result = DataSet.builder((DataSource)source, (DataSet.Kind)DataSet.Kind.COLLECTION);
            this.param.getSheetParam().set(result, (Object)LegacySpreadSheetMoniker.cleanSheetName(id.getSheetName()));
            return result.build();
        }
        if (id.isSeriesByIndex()) {
            return null;
        }
        DataSet.Builder result = DataSet.builder((DataSource)source, (DataSet.Kind)DataSet.Kind.SERIES);
        this.param.getSheetParam().set(result, (Object)LegacySpreadSheetMoniker.cleanSheetName(id.getSheetName()));
        this.param.getSeriesParam().set(result, (Object)id.getSeriesName());
        return result.build();
    }

    private DataSource toDataSource(File file) {
        SpreadSheetBean bean = new SpreadSheetBean();
        bean.setFile(file);
        DataSource.Builder result = DataSource.builder((String)this.providerName, (String)this.param.getVersion());
        this.param.set(result, bean);
        return result.build();
    }

    private static String cleanSheetName(String name) {
        int l = name.lastIndexOf(36);
        if (l < 0) {
            return name;
        }
        if ((name = name.substring(0, l)).charAt(0) == '\'') {
            name = name.substring(1);
        }
        return name.replace('#', '.');
    }

    @Generated
    private LegacySpreadSheetMoniker(String providerName, SpreadSheetParam param) {
        this.providerName = providerName;
        this.param = param;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull LegacySpreadSheetMoniker of(String providerName, SpreadSheetParam param) {
        return new LegacySpreadSheetMoniker(providerName, param);
    }
}

