/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.core;

import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.xml.legacy.XmlDateAdapter;
import jdplus.toolkit.base.xml.legacy.XmlEmptyElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PeriodSelectionType", propOrder={"all", "none", "from", "to", "first", "last", "excludeFirst", "excludeLast"})
public class XmlPeriodSelection {
    @XmlElement(name="All")
    protected XmlEmptyElement all;
    @XmlElement(name="None")
    protected XmlEmptyElement none;
    @XmlElement(name="From")
    @XmlJavaTypeAdapter(value=XmlDateAdapter.class)
    protected LocalDate from;
    @XmlElement(name="To")
    @XmlJavaTypeAdapter(value=XmlDateAdapter.class)
    protected LocalDate to;
    @XmlElement(name="First")
    @XmlSchemaType(name="unsignedInt")
    protected Integer first;
    @XmlElement(name="Last")
    @XmlSchemaType(name="unsignedInt")
    protected Integer last;
    @XmlElement(name="ExcludeFirst")
    @XmlSchemaType(name="unsignedInt")
    protected Integer excludeFirst;
    @XmlElement(name="ExcludeLast")
    @XmlSchemaType(name="unsignedInt")
    protected Integer excludeLast;
    private static final Adapter ADAPTER = new Adapter();

    public XmlEmptyElement getAll() {
        return this.all;
    }

    public void setAll(XmlEmptyElement value) {
        this.all = value;
    }

    public XmlEmptyElement getNone() {
        return this.none;
    }

    public void setNone(XmlEmptyElement value) {
        this.none = value;
    }

    public LocalDate getFrom() {
        return this.from;
    }

    public void setFrom(LocalDate value) {
        this.from = value;
    }

    public LocalDate getTo() {
        return this.to;
    }

    public void setTo(LocalDate value) {
        this.to = value;
    }

    public Integer getFirst() {
        return this.first;
    }

    public void setFirst(Integer value) {
        this.first = value;
    }

    public Integer getLast() {
        return this.last;
    }

    public void setLast(Integer value) {
        this.last = value;
    }

    public Integer getExcludeFirst() {
        return this.excludeFirst;
    }

    public void setExcludeFirst(Integer value) {
        this.excludeFirst = value;
    }

    public Integer getExcludeLast() {
        return this.excludeLast;
    }

    public void setExcludeLast(Integer value) {
        this.excludeLast = value;
    }

    private void clear() {
        this.all = null;
        this.none = null;
        this.from = null;
        this.to = null;
        this.first = null;
        this.last = null;
        this.excludeFirst = null;
        this.excludeLast = null;
    }

    public static Adapter getAdapter() {
        return ADAPTER;
    }

    public static XmlPeriodSelection marshal(TimeSelector v) {
        if (v == null || v.getType() == TimeSelector.SelectionType.All) {
            return null;
        }
        XmlPeriodSelection xml = new XmlPeriodSelection();
        XmlPeriodSelection.marshal(v, xml);
        return xml;
    }

    public static boolean marshal(TimeSelector v, XmlPeriodSelection xml) {
        switch (v.getType()) {
            case All: {
                xml.all = new XmlEmptyElement();
                break;
            }
            case None: {
                xml.none = new XmlEmptyElement();
                break;
            }
            case Between: {
                xml.from = v.getD0().toLocalDate();
                xml.to = v.getD1().toLocalDate();
                break;
            }
            case From: {
                xml.from = v.getD0().toLocalDate();
                break;
            }
            case To: {
                xml.to = v.getD0().toLocalDate();
                break;
            }
            case First: {
                xml.first = v.getN0();
                break;
            }
            case Last: {
                xml.last = v.getN1();
                break;
            }
            case Excluding: {
                xml.excludeFirst = v.getN0();
                xml.excludeLast = v.getN1();
            }
        }
        return true;
    }

    public static TimeSelector unmarshal(XmlPeriodSelection xml) {
        if (xml.all != null) {
            return TimeSelector.all();
        }
        if (xml.none != null) {
            return TimeSelector.none();
        }
        if (xml.from != null && xml.to != null) {
            return TimeSelector.between((LocalDateTime)xml.from.atStartOfDay(), (LocalDateTime)xml.to.atStartOfDay());
        }
        if (xml.from != null) {
            return TimeSelector.from((LocalDateTime)xml.from.atStartOfDay());
        }
        if (xml.to != null) {
            return TimeSelector.from((LocalDateTime)xml.to.atStartOfDay());
        }
        if (xml.first != null) {
            return TimeSelector.first((int)xml.first);
        }
        if (xml.last != null) {
            return TimeSelector.last((int)xml.last);
        }
        return TimeSelector.excluding((int)(xml.excludeFirst == null ? 0 : xml.excludeFirst), (int)(xml.excludeLast == null ? 0 : xml.excludeLast));
    }

    public static class Adapter
    extends XmlAdapter<XmlPeriodSelection, TimeSelector> {
        public TimeSelector unmarshal(XmlPeriodSelection xml) {
            return XmlPeriodSelection.unmarshal(xml);
        }

        public XmlPeriodSelection marshal(TimeSelector v) {
            XmlPeriodSelection xml = new XmlPeriodSelection();
            XmlPeriodSelection.marshal(v, xml);
            return xml;
        }
    }
}

