## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----example------------------------------------------------------------------
library(resLIK)

# 1. Initialize
# Assume z_t is a latent vector from your model (e.g., shape 1x3)
z_t <- c(0.5, -0.2, 0.1) 
z_prev <- c(0.5, -0.2, 0.0) # Previous state at t-1

# Define reference statistics (normally derived from training data)
ref_mean <- 0
ref_sd <- 1

# 2. Sensing
# Check population fit (ResLik)
res_out <- reslik(z_t, ref_mean = ref_mean, ref_sd = ref_sd)
print(paste("ResLik Discrepancy:", res_out$diagnostics$discrepancy))

# Check stability (TCS)
tcs_out <- tcs(z_t, z_prev)
print(paste("TCS Drift:", tcs_out$drift))

# 3. Decision
decision <- rlcs_control(res_out, tcs = tcs_out)
print(paste("Control Signal:", decision))
# Expected: "PROCEED"

