/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.Iterator;
import org.jgrapht.Graph;

public class FloydWarshallShortestPaths<V, E> {
    int nextIndex = 0;
    HashMap<V, Integer> indices;
    double[][] d;
    double diameter;

    public FloydWarshallShortestPaths(Graph<V, E> graph) {
        int n = graph.vertexSet().size();
        this.d = new double[n][n];
        this.indices = new HashMap();
        for (Object object : graph.vertexSet()) {
            for (Object object2 : graph.vertexSet()) {
                if (object == object2) {
                    this.d[this.index(object)][this.index(object2)] = 0.0;
                    continue;
                }
                E e = graph.getEdge(object, object2);
                if (e == null) {
                    this.d[this.index(object)][this.index(object2)] = Double.POSITIVE_INFINITY;
                    continue;
                }
                this.d[this.index(object)][this.index(object2)] = graph.getEdgeWeight(e);
            }
        }
        for (int i = 0; i < n; ++i) {
            for (Iterator<Object> iterator : graph.vertexSet()) {
                for (E e : graph.vertexSet()) {
                    this.d[this.index(iterator)][this.index(e)] = Math.min(this.d[this.index(iterator)][this.index(e)], this.d[this.index(iterator)][i] + this.d[i][this.index(e)]);
                    this.diameter = Math.max(this.diameter, this.d[this.index(iterator)][this.index(e)]);
                }
            }
        }
    }

    public double shortestDistance(V v, V v2) {
        return this.d[this.index(v)][this.index(v2)];
    }

    public double getDiameter() {
        return this.diameter;
    }

    private int index(V v) {
        Integer n = this.indices.get(v);
        if (n == null) {
            this.indices.put((Integer)v, this.nextIndex);
            n = this.nextIndex++;
        }
        return n;
    }
}

