/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.analysis;

import lombok.Generated;

public final class DFT {
    public static double[] transformSymmetric(double[] inr) {
        int T2 = inr.length;
        double[] out = new double[T2];
        int N = 2 * T2 - 1;
        double l = Math.PI * 2 / (double)N;
        double[] cos = new double[T2];
        cos[0] = 1.0;
        for (int i = 1; i < T2; ++i) {
            cos[i] = Math.cos((double)i * l);
        }
        for (int i = 0; i < T2; ++i) {
            double a = inr[0];
            int j = 1;
            int k = i;
            while (j < T2) {
                double r = inr[j];
                int q = k % N;
                if (q >= T2) {
                    q = N - q;
                }
                if (!Double.isNaN(r)) {
                    a += 2.0 * r * cos[q];
                }
                ++j;
                k += i;
            }
            out[i] = a;
        }
        return out;
    }

    public static void transform(double[] inr, double[] outcos, double[] outsin) {
        int T2 = inr.length;
        double l = Math.PI * 2 / (double)T2;
        double cosl = Math.cos(l);
        double sinl = Math.sin(l);
        double cos = 1.0;
        double sin = 0.0;
        for (int i = 0; i < T2; ++i) {
            double a = 0.0;
            double b = 0.0;
            double c = 1.0;
            double s = 0.0;
            for (int j = 0; j < T2; ++j) {
                double r = inr[j];
                double ctmp = c;
                double stmp = s;
                s = cos * stmp + sin * ctmp;
                c = cos * ctmp - sin * stmp;
                if (Double.isNaN(r)) continue;
                a += c * r;
                b += s * r;
            }
            outcos[i] = a;
            outsin[i] = b;
            double ctmp = cos;
            double stmp = sin;
            sin = cosl * stmp + sinl * ctmp;
            cos = -sinl * stmp + cosl * ctmp;
        }
    }

    public static void transform(double[] inr, double[] ini, double[] outcos, double[] outsin) {
        int T2 = inr.length;
        double l = Math.PI * 2 / (double)T2;
        double cosl = Math.cos(l);
        double sinl = Math.sin(l);
        double cos = 1.0;
        double sin = 0.0;
        for (int i = 0; i < T2; ++i) {
            double a = 0.0;
            double b = 0.0;
            double c = 1.0;
            double s = 0.0;
            for (int j = 0; j < T2; ++j) {
                double r = inr[j];
                double im = ini[j];
                if (!Double.isNaN(r)) {
                    a += c * r + s * im;
                    b += c * im - s * r;
                }
                double ctmp = c;
                double stmp = s;
                c = cos * ctmp - sin * stmp;
                s = cos * stmp + sin * ctmp;
            }
            outcos[i] = a;
            outsin[i] = b;
            double ctmp = cos;
            double stmp = sin;
            sin = cosl * stmp + sinl * ctmp;
            cos = -sinl * stmp + cosl * ctmp;
        }
    }

    public static void backTransform(double[] inr, double[] ini, double[] outcos, double[] outsin) {
        int T2 = inr.length;
        double l = Math.PI * 2 / (double)T2;
        double cosl = Math.cos(l);
        double sinl = Math.sin(l);
        double cos = 1.0;
        double sin = 0.0;
        for (int i = 0; i < T2; ++i) {
            double a = 0.0;
            double b = 0.0;
            double c = 1.0;
            double s = 0.0;
            for (int j = 0; j < T2; ++j) {
                double r = inr[j];
                double im = ini[j];
                if (!Double.isNaN(r)) {
                    a += c * r - s * im;
                    b += c * im + s * r;
                }
                double ctmp = c;
                double stmp = s;
                c = cos * ctmp - sin * stmp;
                s = cos * stmp + sin * ctmp;
            }
            outcos[i] = a / (double)T2;
            outsin[i] = b / (double)T2;
            double ctmp = cos;
            double stmp = sin;
            sin = cosl * stmp + sinl * ctmp;
            cos = -sinl * stmp + cosl * ctmp;
        }
    }

    public static void transform2(double[] inr, double[] ini, double[] outcos, double[] outsin) {
        int T2 = inr.length;
        double l = Math.PI * 2 / (double)T2;
        double[] cos = new double[T2];
        double[] sin = new double[T2];
        cos[0] = 1.0;
        for (int i = 1; i < T2; ++i) {
            cos[i] = Math.cos((double)i * l);
            sin[i] = Math.sin((double)i * l);
        }
        for (int i = 0; i < T2; ++i) {
            double a = 0.0;
            double b = 0.0;
            int j = 0;
            int k = 0;
            while (j < T2) {
                double r = inr[j];
                double im = ini[j];
                int q = k % T2;
                if (!Double.isNaN(r)) {
                    a += cos[q] * r + sin[q] * im;
                    b += cos[q] * im - sin[q] * r;
                }
                ++j;
                k += i;
            }
            outcos[i] = a;
            outsin[i] = b;
        }
    }

    public static void backTransform2(double[] inr, double[] ini, double[] outcos, double[] outsin) {
        int T2 = inr.length;
        double l = Math.PI * 2 / (double)T2;
        double[] cos = new double[T2];
        double[] sin = new double[T2];
        cos[0] = 1.0;
        for (int i = 1; i < T2; ++i) {
            cos[i] = Math.cos((double)i * l);
            sin[i] = Math.sin((double)i * l);
        }
        for (int i = 0; i < T2; ++i) {
            double a = 0.0;
            double b = 0.0;
            int j = 0;
            int k = 0;
            while (j < T2) {
                double r = inr[j];
                double im = ini[j];
                int q = k % T2;
                if (!Double.isNaN(r)) {
                    a += cos[q] * r - sin[q] * im;
                    b += cos[q] * im + sin[q] * r;
                }
                ++j;
                k += i;
            }
            outcos[i] = a / (double)T2;
            outsin[i] = b / (double)T2;
        }
    }

    @Generated
    private DFT() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

