/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import standalone_spreadsheet.nbbrd.io.function.IOFunction;

@FunctionalInterface
public interface IOUnaryOperator<T>
extends IOFunction<T, T> {
    @NonNull
    default public UnaryOperator<T> asUnchecked() {
        return t -> {
            try {
                return this.applyWithIO(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @NonNull
    public static <T> UnaryOperator<T> unchecked(@NonNull IOUnaryOperator<T> o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return o.asUnchecked();
    }

    @NonNull
    public static <T> IOUnaryOperator<T> checked(@NonNull UnaryOperator<T> func) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return o -> {
            try {
                return func.apply(o);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        };
    }

    @NonNull
    public static <T> IOUnaryOperator<T> identity() {
        return t -> t;
    }
}

