/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.grid;

import internal.toolkit.base.tsp.grid.InternalValueWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import jdplus.toolkit.base.api.data.Seq;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsDataTable;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.tsp.grid.GridDataType;
import jdplus.toolkit.base.tsp.grid.GridLayout;
import jdplus.toolkit.base.tsp.grid.GridOutput;
import jdplus.toolkit.base.tsp.util.ObsFormat;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class GridWriter {
    public static final GridWriter DEFAULT = GridWriter.builder().build();
    @NonNull
    private final ObsFormat format;
    @NonNull
    private final GridLayout layout;
    private final boolean ignoreNames;
    private final boolean ignoreDates;
    private final String cornerLabel;
    private final boolean reverseChronology;
    private final Function<TsCollection, TsDataTable.DistributionType> colX = col -> TsDataTable.DistributionType.FIRST;
    private final Function<Ts, TsDataTable.DistributionType> seriesX = series -> TsDataTable.DistributionType.FIRST;

    public static Builder builder() {
        Builder result = new Builder();
        result.format = ObsFormat.DEFAULT;
        result.layout = GridLayout.UNDEFINED;
        result.ignoreNames = false;
        result.ignoreDates = false;
        result.cornerLabel = null;
        result.reverseChronology = false;
        return result;
    }

    public void write(@NonNull TsCollection input, @NonNull GridOutput output) throws IOException {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        TsDataTable table = TsDataTable.of((Iterable)input, Ts::getData);
        boolean seriesByRow = this.isSeriesByRow(input);
        int rows = this.getLength(table, seriesByRow);
        int columns = this.getLength(table, !seriesByRow);
        IntFunction<String> names = this.getNames((Seq<Ts>)input);
        IntFunction<LocalDateTime> dates = this.getDates(table.getDomain());
        TsDataTable.Cursor cursor = table.cursor(this.getDistribution((Seq<Ts>)input));
        try (TypedOutputStream stream = TypedOutputStream.of(output.getDataTypes(), this.format, output.open(input.getName(), rows, columns));){
            if (seriesByRow) {
                this.writeSeriesByRow(cursor, stream, names, dates);
            } else {
                this.writePeriodByRow(cursor, stream, names, dates);
            }
        }
    }

    private boolean isSeriesByRow(TsCollection col) {
        return this.layout.equals((Object)GridLayout.HORIZONTAL) || GridWriter.peekSeriesByRow(col);
    }

    private int getLength(TsDataTable table, boolean data) {
        return data ? table.getData().size() + (!this.ignoreDates ? 1 : 0) : table.getDomain().length() + (!this.ignoreNames ? 1 : 0);
    }

    private PrimitiveIterator.OfInt getPeriodIterator(TsDataTable.Cursor input) {
        return this.reverseChronology ? GridWriter.reverseRange(0, input.getPeriodCount()).iterator() : IntStream.range(0, input.getPeriodCount()).iterator();
    }

    private void writePeriodByRow(TsDataTable.Cursor input, TypedOutputStream output, IntFunction<String> names, IntFunction<LocalDateTime> dates) throws IOException {
        this.writePeriodByRowHead(input, output, names);
        this.writePeriodByRowBody(input, output, dates);
    }

    private void writePeriodByRowHead(TsDataTable.Cursor input, TypedOutputStream output, IntFunction<String> names) throws IOException {
        if (!this.ignoreNames) {
            if (!this.ignoreDates) {
                output.writeString(this.cornerLabel);
            }
            for (int series = 0; series < input.getSeriesCount(); ++series) {
                output.writeString(names.apply(series));
            }
            output.writeEndOfRow();
        }
    }

    private void writePeriodByRowBody(TsDataTable.Cursor input, TypedOutputStream output, IntFunction<LocalDateTime> dates) throws IOException {
        PrimitiveIterator.OfInt periods = this.getPeriodIterator(input);
        while (periods.hasNext()) {
            int period = periods.nextInt();
            if (!this.ignoreDates) {
                output.writeDateTime(dates.apply(period));
            }
            for (int series = 0; series < input.getSeriesCount(); ++series) {
                this.writeValue(input, output, period, series);
            }
            output.writeEndOfRow();
        }
    }

    private void writeSeriesByRow(TsDataTable.Cursor input, TypedOutputStream output, IntFunction<String> names, IntFunction<LocalDateTime> dates) throws IOException {
        this.writeSeriesByRowHead(input, output, dates);
        this.writeSeriesByRowBody(input, output, names);
    }

    private void writeSeriesByRowHead(TsDataTable.Cursor input, TypedOutputStream output, IntFunction<LocalDateTime> dates) throws IOException {
        if (!this.ignoreDates) {
            if (!this.ignoreNames) {
                output.writeString(this.cornerLabel);
            }
            PrimitiveIterator.OfInt periods = this.getPeriodIterator(input);
            while (periods.hasNext()) {
                int period = periods.nextInt();
                output.writeDateTime(dates.apply(period));
            }
            output.writeEndOfRow();
        }
    }

    private void writeSeriesByRowBody(TsDataTable.Cursor input, TypedOutputStream output, IntFunction<String> names) throws IOException {
        for (int series = 0; series < input.getSeriesCount(); ++series) {
            if (!this.ignoreNames) {
                output.writeString(names.apply(series));
            }
            PrimitiveIterator.OfInt periods = this.getPeriodIterator(input);
            while (periods.hasNext()) {
                this.writeValue(input, output, periods.nextInt(), series);
            }
            output.writeEndOfRow();
        }
    }

    private void writeValue(TsDataTable.Cursor input, TypedOutputStream output, int period, int series) throws IOException {
        input.moveTo(period, series);
        if (input.getStatus() == TsDataTable.ValueStatus.PRESENT) {
            output.writeDouble(this.nanToNull(input.getValue()));
        } else {
            output.writeDouble(null);
        }
    }

    private Double nanToNull(double value) {
        return Double.isNaN(value) ? null : Double.valueOf(value);
    }

    private IntFunction<String> getNames(Seq<Ts> col) {
        return seriesIndex -> ((Ts)col.get(seriesIndex)).getName();
    }

    private IntFunction<LocalDateTime> getDates(TsDomain domain) {
        return seriesIndex -> domain.get(seriesIndex).start();
    }

    private IntFunction<TsDataTable.DistributionType> getDistribution(Seq<Ts> col) {
        return seriesIndex -> this.seriesX.apply((Ts)col.get(seriesIndex));
    }

    private static boolean peekSeriesByRow(TsCollection col) {
        return GridLayout.HORIZONTAL.name().equals(col.getMeta().get("gridLayout"));
    }

    static IntStream reverseRange(int from, int to) {
        return IntStream.range(from, to).map(i -> to - i + from - 1);
    }

    @Generated
    GridWriter(@NonNull ObsFormat format, @NonNull GridLayout layout, boolean ignoreNames, boolean ignoreDates, String cornerLabel, boolean reverseChronology) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (layout == null) {
            throw new NullPointerException("layout is marked non-null but is null");
        }
        this.format = format;
        this.layout = layout;
        this.ignoreNames = ignoreNames;
        this.ignoreDates = ignoreDates;
        this.cornerLabel = cornerLabel;
        this.reverseChronology = reverseChronology;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().format(this.format).layout(this.layout).ignoreNames(this.ignoreNames).ignoreDates(this.ignoreDates).cornerLabel(this.cornerLabel).reverseChronology(this.reverseChronology);
    }

    @NonNull
    @Generated
    public ObsFormat getFormat() {
        return this.format;
    }

    @NonNull
    @Generated
    public GridLayout getLayout() {
        return this.layout;
    }

    @Generated
    public boolean isIgnoreNames() {
        return this.ignoreNames;
    }

    @Generated
    public boolean isIgnoreDates() {
        return this.ignoreDates;
    }

    @Generated
    public String getCornerLabel() {
        return this.cornerLabel;
    }

    @Generated
    public boolean isReverseChronology() {
        return this.reverseChronology;
    }

    @Generated
    public Function<TsCollection, TsDataTable.DistributionType> getColX() {
        return this.colX;
    }

    @Generated
    public Function<Ts, TsDataTable.DistributionType> getSeriesX() {
        return this.seriesX;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GridWriter)) {
            return false;
        }
        GridWriter other = (GridWriter)o;
        if (this.isIgnoreNames() != other.isIgnoreNames()) {
            return false;
        }
        if (this.isIgnoreDates() != other.isIgnoreDates()) {
            return false;
        }
        if (this.isReverseChronology() != other.isReverseChronology()) {
            return false;
        }
        ObsFormat this$format = this.getFormat();
        ObsFormat other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)this$format).equals(other$format)) {
            return false;
        }
        GridLayout this$layout = this.getLayout();
        GridLayout other$layout = other.getLayout();
        if (this$layout == null ? other$layout != null : !((Object)((Object)this$layout)).equals((Object)other$layout)) {
            return false;
        }
        String this$cornerLabel = this.getCornerLabel();
        String other$cornerLabel = other.getCornerLabel();
        if (this$cornerLabel == null ? other$cornerLabel != null : !this$cornerLabel.equals(other$cornerLabel)) {
            return false;
        }
        Function<TsCollection, TsDataTable.DistributionType> this$colX = this.getColX();
        Function<TsCollection, TsDataTable.DistributionType> other$colX = other.getColX();
        if (this$colX == null ? other$colX != null : !this$colX.equals(other$colX)) {
            return false;
        }
        Function<Ts, TsDataTable.DistributionType> this$seriesX = this.getSeriesX();
        Function<Ts, TsDataTable.DistributionType> other$seriesX = other.getSeriesX();
        return !(this$seriesX == null ? other$seriesX != null : !this$seriesX.equals(other$seriesX));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIgnoreNames() ? 79 : 97);
        result = result * 59 + (this.isIgnoreDates() ? 79 : 97);
        result = result * 59 + (this.isReverseChronology() ? 79 : 97);
        ObsFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        GridLayout $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : ((Object)((Object)$layout)).hashCode());
        String $cornerLabel = this.getCornerLabel();
        result = result * 59 + ($cornerLabel == null ? 43 : $cornerLabel.hashCode());
        Function<TsCollection, TsDataTable.DistributionType> $colX = this.getColX();
        result = result * 59 + ($colX == null ? 43 : $colX.hashCode());
        Function<Ts, TsDataTable.DistributionType> $seriesX = this.getSeriesX();
        result = result * 59 + ($seriesX == null ? 43 : $seriesX.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "GridWriter(format=" + String.valueOf(this.getFormat()) + ", layout=" + String.valueOf((Object)this.getLayout()) + ", ignoreNames=" + this.isIgnoreNames() + ", ignoreDates=" + this.isIgnoreDates() + ", cornerLabel=" + this.getCornerLabel() + ", reverseChronology=" + this.isReverseChronology() + ", colX=" + String.valueOf(this.getColX()) + ", seriesX=" + String.valueOf(this.getSeriesX()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private ObsFormat format;
        @Generated
        private GridLayout layout;
        @Generated
        private boolean ignoreNames;
        @Generated
        private boolean ignoreDates;
        @Generated
        private String cornerLabel;
        @Generated
        private boolean reverseChronology;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder format(@NonNull ObsFormat format) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            this.format = format;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder layout(@NonNull GridLayout layout) {
            if (layout == null) {
                throw new NullPointerException("layout is marked non-null but is null");
            }
            this.layout = layout;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ignoreNames(boolean ignoreNames) {
            this.ignoreNames = ignoreNames;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ignoreDates(boolean ignoreDates) {
            this.ignoreDates = ignoreDates;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder cornerLabel(String cornerLabel) {
            this.cornerLabel = cornerLabel;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder reverseChronology(boolean reverseChronology) {
            this.reverseChronology = reverseChronology;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull GridWriter build() {
            return new GridWriter(this.format, this.layout, this.ignoreNames, this.ignoreDates, this.cornerLabel, this.reverseChronology);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "GridWriter.Builder(format=" + String.valueOf(this.format) + ", layout=" + String.valueOf((Object)this.layout) + ", ignoreNames=" + this.ignoreNames + ", ignoreDates=" + this.ignoreDates + ", cornerLabel=" + this.cornerLabel + ", reverseChronology=" + this.reverseChronology + ")";
        }
    }

    private static final class TypedOutputStream
    implements GridOutput.Stream {
        @NonNull
        private final InternalValueWriter<String> string;
        @NonNull
        private final InternalValueWriter<LocalDateTime> dateTime;
        @NonNull
        private final InternalValueWriter<Double> number;
        @NonNull
        private final GridOutput.Stream delegate;

        static TypedOutputStream of(Set<GridDataType> dataTypes, ObsFormat format, GridOutput.Stream stream) {
            InternalValueWriter<LocalDateTime> dateTime;
            InternalValueWriter<String> string;
            boolean stringSupported = dataTypes.contains((Object)GridDataType.STRING);
            InternalValueWriter<String> internalValueWriter = string = stringSupported ? InternalValueWriter.onString() : InternalValueWriter.onNull();
            InternalValueWriter<LocalDateTime> internalValueWriter2 = dataTypes.contains((Object)GridDataType.LOCAL_DATE_TIME) ? InternalValueWriter.onDateTime() : (stringSupported ? InternalValueWriter.onStringFormatter(arg_0 -> format.dateTimeFormatter().formatAsString(arg_0)) : (dateTime = InternalValueWriter.onNull()));
            InternalValueWriter<Double> number = dataTypes.contains((Object)GridDataType.DOUBLE) ? InternalValueWriter.onDouble() : (stringSupported ? InternalValueWriter.onStringFormatter(arg_0 -> format.numberFormatter().formatAsString(arg_0)) : InternalValueWriter.onNull());
            return new TypedOutputStream(string, dateTime, number, stream);
        }

        public void writeString(@Nullable String value) throws IOException {
            this.string.write(this.delegate, value);
        }

        public void writeDateTime(@Nullable LocalDateTime value) throws IOException {
            this.dateTime.write(this.delegate, value);
        }

        public void writeDouble(@Nullable Double value) throws IOException {
            this.number.write(this.delegate, value);
        }

        @Generated
        private TypedOutputStream(@NonNull InternalValueWriter<String> string, @NonNull InternalValueWriter<LocalDateTime> dateTime, @NonNull InternalValueWriter<Double> number, @NonNull GridOutput.Stream delegate) {
            if (string == null) {
                throw new NullPointerException("string is marked non-null but is null");
            }
            if (dateTime == null) {
                throw new NullPointerException("dateTime is marked non-null but is null");
            }
            if (number == null) {
                throw new NullPointerException("number is marked non-null but is null");
            }
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.string = string;
            this.dateTime = dateTime;
            this.number = number;
            this.delegate = delegate;
        }

        @Override
        @Generated
        public void writeCell(Object value) throws IOException {
            this.delegate.writeCell(value);
        }

        @Override
        @Generated
        public void writeEndOfRow() throws IOException {
            this.delegate.writeEndOfRow();
        }

        @Override
        @Generated
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

