/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.modelling;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.xml.legacy.arima.XmlSarimaOrders;
import jdplus.toolkit.base.xml.legacy.arima.XmlSarimaPolynomials;
import jdplus.toolkit.base.xml.legacy.modelling.XmlMeanCorrection;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ArimaSpecType", propOrder={"mean", "orders", "polynomials"})
public class XmlArimaSpec {
    @XmlElement(name="Mean")
    protected XmlMeanCorrection mean;
    @XmlElement(name="Orders")
    protected XmlSarimaOrders orders;
    @XmlElement(name="Polynomials")
    protected XmlSarimaPolynomials polynomials;

    public XmlMeanCorrection getMean() {
        return this.mean;
    }

    public void setMean(XmlMeanCorrection value) {
        this.mean = value;
    }

    public XmlSarimaOrders getOrders() {
        return this.orders;
    }

    public void setOrders(XmlSarimaOrders value) {
        this.orders = value;
    }

    public XmlSarimaPolynomials getPolynomials() {
        return this.polynomials;
    }

    public void setPolynomials(XmlSarimaPolynomials value) {
        this.polynomials = value;
    }

    public static boolean marshal(SarimaSpec v, XmlArimaSpec xml) {
        if (v.isUndefined()) {
            XmlSarimaOrders orders = new XmlSarimaOrders();
            orders.setP(v.getP());
            orders.setD(v.getD());
            orders.setQ(v.getQ());
            orders.setBP(v.getBp());
            orders.setBD(v.getBd());
            orders.setBQ(v.getBq());
            xml.setOrders(orders);
        } else {
            XmlSarimaPolynomials polynomials = new XmlSarimaPolynomials();
            polynomials.setD(v.getD());
            polynomials.setBD(v.getBd());
            polynomials.setAR(v.getPhi());
            polynomials.setMA(v.getTheta());
            polynomials.setBAR(v.getBphi());
            polynomials.setBMA(v.getBtheta());
            xml.setPolynomials(polynomials);
        }
        return true;
    }

    public static SarimaSpec unmarshal(XmlArimaSpec xml) {
        SarimaSpec.Builder builder = SarimaSpec.builder();
        if (xml.orders != null) {
            builder = builder.p(xml.orders.getP()).d(xml.orders.getD()).q(xml.orders.getQ()).bp(xml.orders.getBP()).bd(xml.orders.getBD()).bq(xml.orders.getBQ());
        } else if (xml.polynomials != null) {
            if (xml.polynomials.getD() != null) {
                builder = builder.d(xml.polynomials.getD().intValue());
            }
            if (xml.polynomials.getBD() != null) {
                builder = builder.bd(xml.polynomials.getBD().intValue());
            }
            builder = builder.phi(xml.polynomials.getAR()).theta(xml.polynomials.getMA()).bphi(xml.polynomials.getBAR()).btheta(xml.polynomials.getBMA());
        }
        return (SarimaSpec)builder.build();
    }
}

