/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.cmd;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import usf.saav.cmd.TestResults;
import usf.saav.common.SystemX;
import usf.saav.common.TimerMillisecond;
import usf.saav.topology.reebgraph.ReebGraph;
import usf.saav.topology.reebgraph.ReebGraphLoader;

public class SingleTestCLI {
    public static void main(String[] stringArray) {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("input.properties"));
            String string = properties.getProperty("inputFile").trim();
            boolean bl = properties.getProperty("verbose").trim().equalsIgnoreCase("true");
            boolean bl2 = properties.getProperty("saveGraphDot").trim().equalsIgnoreCase("true");
            int n = Integer.parseInt(properties.getProperty("repeatTest").trim());
            String string2 = properties.getProperty("outputPath").trim() + "/";
            System.out.println("Input File: " + string);
            if (bl2) {
                SingleTestCLI.saveGraph(string, string2, bl);
            }
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < n; ++i) {
                TestResults testResults = TestResults.testPerformance(string, bl);
                if (testResults != null) {
                    System.out.println("test succeeded: " + string + " -- merge_time: " + testResults.mergeTimer.getElapsedMilliseconds() + " pp_timer: " + testResults.ppTimer.getElapsedMilliseconds());
                } else {
                    System.out.println("test FAILED: " + string);
                }
                d += testResults.mergeTimer.getElapsedMilliseconds();
                d2 += testResults.ppTimer.getElapsedMilliseconds();
                bl = false;
            }
            System.out.println("Average -- Merge: " + d / (double)n + ", P&P: " + d2 / (double)n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Invalid input. Check the input.properties file");
            System.exit(0);
        }
    }

    public static void saveGraph(String string, String string2, boolean bl) throws Exception {
        TimerMillisecond timerMillisecond = new TimerMillisecond();
        timerMillisecond.start();
        ArrayList<ReebGraph> arrayList = ReebGraphLoader.load(string, true, false, bl);
        timerMillisecond.end();
        if (bl) {
            System.out.println("  Load time: " + timerMillisecond.getElapsedMilliseconds() + "ms");
        }
        timerMillisecond.start();
        for (int i = 0; i < arrayList.size(); ++i) {
            SystemX.writeStringToFile(arrayList.get(i).toDot(), string2 + "graph" + i + ".dot");
        }
        timerMillisecond.end();
        if (bl) {
            System.out.println("  Save time: " + timerMillisecond.getElapsedMilliseconds() + "ms");
        }
    }
}

